/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private List<NameRecord> nameRecords;
    private Map<Integer, Map<Integer, Map<Integer, Map<Integer, String>>>> lookupTable;
    private String fontFamily = null;
    private String fontSubFamily = null;
    private String psName = null;

    NamingTable() {
    }

    @Override
    void read(TrueTypeFont object, TTFDataStream tTFDataStream) {
        Object object2;
        tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        tTFDataStream.readUnsignedShort();
        this.nameRecords = new ArrayList<NameRecord>(n2);
        for (int i = 0; i < n2; ++i) {
            NameRecord nameRecord = new NameRecord();
            nameRecord.initData((TrueTypeFont)object, tTFDataStream);
            this.nameRecords.add(nameRecord);
        }
        for (NameRecord nameRecord : this.nameRecords) {
            if ((long)nameRecord.getStringOffset() > this.getLength()) {
                nameRecord.setString(null);
                continue;
            }
            tTFDataStream.seek(this.getOffset() + 6L + ((long)n2 << 1) * 6L + (long)nameRecord.getStringOffset());
            int n3 = nameRecord.getPlatformId();
            int n4 = nameRecord.getPlatformEncodingId();
            object2 = StandardCharsets.ISO_8859_1;
            if (n3 == 3 && (n4 == 0 || n4 == 1)) {
                object2 = StandardCharsets.UTF_16;
            } else if (n3 == 0) {
                object2 = StandardCharsets.UTF_16;
            } else if (n3 == 2) {
                switch (n4) {
                    case 0: {
                        object2 = StandardCharsets.US_ASCII;
                        break;
                    }
                    case 1: {
                        object2 = StandardCharsets.UTF_16BE;
                        break;
                    }
                    case 2: {
                        object2 = StandardCharsets.ISO_8859_1;
                    }
                }
            }
            object = tTFDataStream.readString(nameRecord.getStringLength(), (Charset)object2);
            nameRecord.setString((String)object);
        }
        this.lookupTable = new HashMap<Integer, Map<Integer, Map<Integer, Map<Integer, String>>>>(this.nameRecords.size());
        for (NameRecord nameRecord : this.nameRecords) {
            object = this.lookupTable.computeIfAbsent(nameRecord.getNameId(), n -> new HashMap());
            Map map = object.computeIfAbsent(nameRecord.getPlatformId(), n -> new HashMap());
            object2 = map.computeIfAbsent(nameRecord.getPlatformEncodingId(), n -> new HashMap(1));
            object2.put(nameRecord.getLanguageId(), nameRecord.getString());
        }
        this.fontFamily = this.getEnglishName(1);
        this.fontSubFamily = this.getEnglishName(2);
        this.psName = this.getName(6, 1, 0, 0);
        if (this.psName == null) {
            this.psName = this.getName(6, 3, 1, 1033);
        }
        if (this.psName != null) {
            this.psName = this.psName.trim();
        }
        this.initialized = true;
    }

    private String getEnglishName(int n) {
        for (int i = 4; i >= 0; --i) {
            String string = this.getName(n, 0, i, 0);
            if (string == null) continue;
            return string;
        }
        String string = this.getName(n, 3, 1, 1033);
        if (string != null) {
            return string;
        }
        return this.getName(n, 1, 0, 0);
    }

    public String getName(int n, int n2, int n3, int n4) {
        Map<Integer, Object> map = this.lookupTable.get(n);
        if (map == null) {
            return null;
        }
        if ((map = map.get(n2)) == null) {
            return null;
        }
        if ((map = map.get(n3)) == null) {
            return null;
        }
        return (String)map.get(n4);
    }

    public List<NameRecord> getNameRecords() {
        return this.nameRecords;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSubFamily() {
        return this.fontSubFamily;
    }

    public String getPostScriptName() {
        return this.psName;
    }
}

