/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.a.d.a;
import org.apache.a.d.e;
import org.apache.fontbox.ttf.TTFDataStream;

class RandomAccessReadDataStream
extends TTFDataStream {
    private final long length;
    private final byte[] data;
    private int currentPosition = 0;

    RandomAccessReadDataStream(e e2) {
        int n;
        this.length = e2.c();
        this.data = new byte[(int)this.length];
        int n2 = this.data.length;
        while ((n = e2.a(this.data, this.data.length - n2, n2)) > 0) {
            n2 -= n;
        }
    }

    RandomAccessReadDataStream(InputStream inputStream) {
        this.data = a.a((InputStream)inputStream);
        this.length = this.data.length;
    }

    @Override
    public long getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public void close() {
    }

    @Override
    public int read() {
        if ((long)this.currentPosition >= this.length) {
            return -1;
        }
        return this.data[this.currentPosition++] & 0xFF;
    }

    @Override
    public final long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    private int readInt() {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    @Override
    public void seek(long l) {
        if (l < 0L) {
            throw new IOException("Invalid position " + l);
        }
        this.currentPosition = l < this.length ? (int)l : (int)this.length;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if ((long)this.currentPosition >= this.length) {
            return -1;
        }
        int n3 = (int)(this.length - (long)this.currentPosition);
        n2 = Math.min(n3, n2);
        System.arraycopy(this.data, this.currentPosition, byArray, n, n2);
        this.currentPosition += n2;
        return n2;
    }

    @Override
    public InputStream getOriginalData() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getOriginalDataSize() {
        return this.length;
    }
}

