/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.FileMonitor;
import com.sun.jna.platform.FileMonitor$FileEvent;
import com.sun.jna.platform.win32.BaseTSD$ULONG_PTRByReference;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.W32FileMonitor$1;
import com.sun.jna.platform.win32.W32FileMonitor$FileInfo;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT$FILE_NOTIFY_INFORMATION;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class W32FileMonitor
extends FileMonitor {
    private static final Logger LOG = Logger.getLogger(W32FileMonitor.class.getName());
    private static final int BUFFER_SIZE = 4096;
    private Thread watcher;
    private WinNT$HANDLE port;
    private final Map<File, W32FileMonitor$FileInfo> fileMap = new HashMap<File, W32FileMonitor$FileInfo>();
    private final Map<WinNT$HANDLE, W32FileMonitor$FileInfo> handleMap = new HashMap<WinNT$HANDLE, W32FileMonitor$FileInfo>();
    private boolean disposing = false;
    private static int watcherThreadID;

    private void handleChanges(W32FileMonitor$FileInfo w32FileMonitor$FileInfo) {
        Kernel32 kernel32 = Kernel32.INSTANCE;
        WinNT$FILE_NOTIFY_INFORMATION winNT$FILE_NOTIFY_INFORMATION = w32FileMonitor$FileInfo.info;
        winNT$FILE_NOTIFY_INFORMATION.read();
        do {
            FileMonitor$FileEvent fileMonitor$FileEvent = null;
            File file = new File(w32FileMonitor$FileInfo.file, winNT$FILE_NOTIFY_INFORMATION.getFilename());
            switch (winNT$FILE_NOTIFY_INFORMATION.Action) {
                case 0: {
                    break;
                }
                case 3: {
                    fileMonitor$FileEvent = new FileMonitor$FileEvent(this, file, 4);
                    break;
                }
                case 1: {
                    fileMonitor$FileEvent = new FileMonitor$FileEvent(this, file, 1);
                    break;
                }
                case 2: {
                    fileMonitor$FileEvent = new FileMonitor$FileEvent(this, file, 2);
                    break;
                }
                case 4: {
                    fileMonitor$FileEvent = new FileMonitor$FileEvent(this, file, 16);
                    break;
                }
                case 5: {
                    fileMonitor$FileEvent = new FileMonitor$FileEvent(this, file, 32);
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unrecognized file action ''{0}''", winNT$FILE_NOTIFY_INFORMATION.Action);
                }
            }
            if (fileMonitor$FileEvent == null) continue;
            this.notify(fileMonitor$FileEvent);
        } while ((winNT$FILE_NOTIFY_INFORMATION = winNT$FILE_NOTIFY_INFORMATION.next()) != null);
        if (!w32FileMonitor$FileInfo.file.exists()) {
            this.unwatch(w32FileMonitor$FileInfo.file);
            return;
        }
        if (!kernel32.ReadDirectoryChangesW(w32FileMonitor$FileInfo.handle, w32FileMonitor$FileInfo.info, w32FileMonitor$FileInfo.info.size(), w32FileMonitor$FileInfo.recursive, w32FileMonitor$FileInfo.notifyMask, w32FileMonitor$FileInfo.infoLength, w32FileMonitor$FileInfo.overlapped, null) && !this.disposing) {
            int n = kernel32.GetLastError();
            throw new IOException("ReadDirectoryChangesW failed on " + w32FileMonitor$FileInfo.file + ": '" + Kernel32Util.formatMessageFromLastErrorCode(n) + "' (" + n + ")");
        }
    }

    private W32FileMonitor$FileInfo waitForChange() {
        Object object = new IntByReference();
        BaseTSD$ULONG_PTRByReference baseTSD$ULONG_PTRByReference = new BaseTSD$ULONG_PTRByReference();
        PointerByReference pointerByReference = new PointerByReference();
        if (!Kernel32.INSTANCE.GetQueuedCompletionStatus(this.port, (IntByReference)object, baseTSD$ULONG_PTRByReference, pointerByReference, -1)) {
            return null;
        }
        object = this;
        synchronized (object) {
            return this.handleMap.get((Object)new WinNT$HANDLE(baseTSD$ULONG_PTRByReference.getValue().toPointer()));
        }
    }

    private int convertMask(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 = 64;
        }
        if ((n & 2) != 0) {
            n2 |= 3;
        }
        if ((n & 4) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x30) != 0) {
            n2 |= 3;
        }
        if ((n & 0x40) != 0) {
            n2 |= 8;
        }
        if ((n & 8) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0x80) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100) != 0) {
            n2 |= 0x100;
        }
        return n2;
    }

    @Override
    protected synchronized void watch(File file, int n, boolean bl) {
        Object object = file;
        if (!((File)object).isDirectory()) {
            bl = false;
            object = file.getParentFile();
        }
        while (object != null && !((File)object).exists()) {
            bl = true;
            object = ((File)object).getParentFile();
        }
        if (object == null) {
            throw new FileNotFoundException("No ancestor found for " + file);
        }
        object = Kernel32.INSTANCE;
        WinNT$HANDLE winNT$HANDLE = object.CreateFile(file.getAbsolutePath(), 1, 7, null, 3, 0x42000000, null);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLE)) {
            throw new IOException("Unable to open " + file + " (" + object.GetLastError() + ")");
        }
        n = this.convertMask(n);
        W32FileMonitor$FileInfo w32FileMonitor$FileInfo = new W32FileMonitor$FileInfo(this, file, winNT$HANDLE, n, bl);
        this.fileMap.put(file, w32FileMonitor$FileInfo);
        this.handleMap.put(winNT$HANDLE, w32FileMonitor$FileInfo);
        this.port = object.CreateIoCompletionPort(winNT$HANDLE, this.port, winNT$HANDLE.getPointer(), 0);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)this.port)) {
            throw new IOException("Unable to create/use I/O Completion port for " + file + " (" + object.GetLastError() + ")");
        }
        if (!object.ReadDirectoryChangesW(winNT$HANDLE, w32FileMonitor$FileInfo.info, w32FileMonitor$FileInfo.info.size(), bl, n, w32FileMonitor$FileInfo.infoLength, w32FileMonitor$FileInfo.overlapped, null)) {
            int n2 = object.GetLastError();
            throw new IOException("ReadDirectoryChangesW failed on " + w32FileMonitor$FileInfo.file + ", handle " + (Object)((Object)winNT$HANDLE) + ": '" + Kernel32Util.formatMessageFromLastErrorCode(n2) + "' (" + n2 + ")");
        }
        if (this.watcher == null) {
            this.watcher = new W32FileMonitor$1(this, "W32 File Monitor-" + watcherThreadID++);
            this.watcher.setDaemon(true);
            this.watcher.start();
        }
    }

    @Override
    protected synchronized void unwatch(File object) {
        if ((object = this.fileMap.remove(object)) != null) {
            this.handleMap.remove((Object)((W32FileMonitor$FileInfo)object).handle);
            Kernel32 kernel32 = Kernel32.INSTANCE;
            kernel32.CloseHandle(((W32FileMonitor$FileInfo)object).handle);
        }
    }

    @Override
    public synchronized void dispose() {
        this.disposing = true;
        int n = 0;
        Object object = this.fileMap.keySet().toArray();
        while (!this.fileMap.isEmpty()) {
            this.unwatch((File)object[n++]);
        }
        object = Kernel32.INSTANCE;
        object.PostQueuedCompletionStatus(this.port, 0, null, null);
        object.CloseHandle(this.port);
        this.port = null;
        this.watcher = null;
    }

    static /* synthetic */ W32FileMonitor$FileInfo access$000(W32FileMonitor w32FileMonitor) {
        return w32FileMonitor.waitForChange();
    }

    static /* synthetic */ Map access$100(W32FileMonitor w32FileMonitor) {
        return w32FileMonitor.fileMap;
    }

    static /* synthetic */ Thread access$202(W32FileMonitor w32FileMonitor, Thread thread) {
        w32FileMonitor.watcher = thread;
        return w32FileMonitor.watcher;
    }

    static /* synthetic */ void access$300(W32FileMonitor w32FileMonitor, W32FileMonitor$FileInfo w32FileMonitor$FileInfo) {
        w32FileMonitor.handleChanges(w32FileMonitor$FileInfo);
    }
}

