/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeRestoringConnectionInvocationHandler
implements InvocationHandler {
    private Connection conn;
    private boolean overwroteOriginalAutoCommitValue;
    private boolean overwroteOriginalTxIsolationValue;
    private boolean originalAutoCommitValue;
    private int originalTxIsolationValue;

    public AttributeRestoringConnectionInvocationHandler(Connection connection) {
        this.conn = connection;
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (method.getName().equals("setAutoCommit")) {
            this.setAutoCommit((Boolean)objectArray[0]);
        } else if (method.getName().equals("setTransactionIsolation")) {
            this.setTransactionIsolation((Integer)objectArray[0]);
        } else if (method.getName().equals("close")) {
            this.close();
        } else {
            try {
                return method.invoke((Object)this.conn, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException;
                throw invocationTargetException.getCause() != null ? ((InvocationTargetException)object).getCause() : object;
            }
        }
        return null;
    }

    public void setAutoCommit(boolean bl) {
        boolean bl2 = this.conn.getAutoCommit();
        if (bl != bl2) {
            if (!this.overwroteOriginalAutoCommitValue) {
                this.overwroteOriginalAutoCommitValue = true;
                this.originalAutoCommitValue = bl2;
            }
            this.conn.setAutoCommit(bl);
        }
    }

    public void setTransactionIsolation(int n) {
        int n2 = this.conn.getTransactionIsolation();
        if (n != n2) {
            if (!this.overwroteOriginalTxIsolationValue) {
                this.overwroteOriginalTxIsolationValue = true;
                this.originalTxIsolationValue = n2;
            }
            this.conn.setTransactionIsolation(n);
        }
    }

    public Connection getWrappedConnection() {
        return this.conn;
    }

    public void restoreOriginalAtributes() {
        try {
            if (this.overwroteOriginalAutoCommitValue) {
                this.conn.setAutoCommit(this.originalAutoCommitValue);
            }
        }
        catch (Throwable throwable) {
            this.getLog().warn("Failed restore connection's original auto commit setting.", throwable);
        }
        try {
            if (this.overwroteOriginalTxIsolationValue) {
                this.conn.setTransactionIsolation(this.originalTxIsolationValue);
            }
            return;
        }
        catch (Throwable throwable) {
            this.getLog().warn("Failed restore connection's original transaction isolation setting.", throwable);
            return;
        }
    }

    public void close() {
        this.restoreOriginalAtributes();
        this.conn.close();
    }
}

