/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.triggers;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CoreTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTriggerImpl
extends AbstractTrigger<CronTrigger>
implements CronTrigger,
CoreTrigger {
    private static final long serialVersionUID = -8644953146451592766L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CronTriggerImpl.class);
    protected static final int YEAR_TO_GIVEUP_SCHEDULING_AT = CronExpression.MAX_YEAR;
    private CronExpression cronEx = null;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private transient TimeZone timeZone = null;

    public CronTriggerImpl() {
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Deprecated
    public CronTriggerImpl(String string) {
        this(string, null);
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2) {
        super(string, string2);
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2, String string3) {
        super(string, string2);
        this.setCronExpression(string3);
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, null, null, string5, TimeZone.getDefault());
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2, String string3, String string4, String string5, TimeZone timeZone) {
        this(string, string2, string3, string4, null, null, string5, timeZone);
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2, String string3, String string4, Date date, Date date2, String string5) {
        super(string, string2, string3, string4);
        this.setCronExpression(string5);
        if (date == null) {
            date = new Date();
        }
        this.setStartTime(date);
        if (date2 != null) {
            this.setEndTime(date2);
        }
        this.setTimeZone(TimeZone.getDefault());
    }

    @Deprecated
    public CronTriggerImpl(String string, String string2, String string3, String string4, Date date, Date date2, String string5, TimeZone timeZone) {
        super(string, string2, string3, string4);
        this.setCronExpression(string5);
        if (date == null) {
            date = new Date();
        }
        this.setStartTime(date);
        if (date2 != null) {
            this.setEndTime(date2);
        }
        if (timeZone == null) {
            this.setTimeZone(TimeZone.getDefault());
            return;
        }
        this.setTimeZone(timeZone);
    }

    @Override
    public Object clone() {
        CronTriggerImpl cronTriggerImpl = (CronTriggerImpl)super.clone();
        if (this.cronEx != null) {
            cronTriggerImpl.setCronExpression(new CronExpression(this.cronEx));
        }
        return cronTriggerImpl;
    }

    public void setCronExpression(String string) {
        TimeZone timeZone = this.getTimeZone();
        this.cronEx = new CronExpression(string);
        this.cronEx.setTimeZone(timeZone);
    }

    @Override
    public String getCronExpression() {
        if (this.cronEx == null) {
            return null;
        }
        return this.cronEx.getCronExpression();
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronEx = cronExpression;
        this.timeZone = cronExpression.getTimeZone();
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Comparable<Date> comparable = this.getEndTime();
        if (comparable != null && ((Date)comparable).before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        comparable = java.util.Calendar.getInstance();
        ((java.util.Calendar)comparable).setTime(date);
        ((java.util.Calendar)comparable).set(14, 0);
        this.startTime = ((java.util.Calendar)comparable).getTime();
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = date;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.nextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.previousFireTime = date;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.cronEx != null) {
            return this.cronEx.getTimeZone();
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.cronEx != null) {
            this.cronEx.setTimeZone(timeZone);
        }
        this.timeZone = timeZone;
    }

    @Override
    public Date getFireTimeAfter(Date date) {
        if (date == null) {
            date = new Date();
        }
        if (this.getStartTime().after(date)) {
            date = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && date.compareTo(this.getEndTime()) >= 0) {
            return null;
        }
        date = this.getTimeAfter(date);
        if (this.getEndTime() != null && date != null && date.after(this.getEndTime())) {
            return null;
        }
        return date;
    }

    @Override
    public Date getFinalFireTime() {
        Date date;
        if ((this.getEndTime() != null ? this.getTimeBefore(new Date(this.getEndTime().getTime() + 1000L)) : (date = this.cronEx == null ? null : this.cronEx.getFinalFireTime())) != null && this.getStartTime() != null && date.before(this.getStartTime())) {
            return null;
        }
        return date;
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    protected boolean validateMisfireInstruction(int n) {
        return n >= -1 && n <= 2;
    }

    @Override
    public void updateAfterMisfire(Calendar calendar) {
        int n = this.getMisfireInstruction();
        if (n == -1) {
            return;
        }
        if (n == 0) {
            n = 1;
        }
        if (n == 2) {
            Date date = this.getFireTimeAfter(new Date());
            while (date != null && calendar != null && !calendar.isTimeIncluded(date.getTime())) {
                date = this.getFireTimeAfter(date);
            }
            this.setNextFireTime(date);
            return;
        }
        if (n == 1) {
            this.setNextFireTime(new Date());
        }
    }

    public boolean willFireOn(java.util.Calendar calendar) {
        return this.willFireOn(calendar, false);
    }

    public boolean willFireOn(java.util.Calendar calendar, boolean bl) {
        calendar = (java.util.Calendar)calendar.clone();
        calendar.set(14, 0);
        if (bl) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        Date date = calendar.getTime();
        Date date2 = this.getFireTimeAfter(new Date(calendar.getTime().getTime() - 1000L));
        if (date2 == null) {
            return false;
        }
        java.util.Calendar calendar2 = java.util.Calendar.getInstance(calendar.getTimeZone());
        calendar2.setTime(date2);
        int n = calendar2.get(1);
        int n2 = calendar2.get(2);
        int n3 = calendar2.get(5);
        if (bl) {
            return n == calendar.get(1) && n2 == calendar.get(2) && n3 == calendar.get(5);
        }
        while (date2.before(date)) {
            date2 = this.getFireTimeAfter(date2);
        }
        return date2.equals(date);
    }

    @Override
    public void triggered(Calendar calendar) {
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    @Override
    public void updateWithNewCalendar(Calendar calendar, long l) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date date = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long l2;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.nextFireTime);
            if (gregorianCalendar.get(1) > YEAR_TO_GIVEUP_SCHEDULING_AT) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(date) || (l2 = date.getTime() - this.nextFireTime.getTime()) < l) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L));
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
        return this.nextFireTime;
    }

    @Override
    public String getExpressionSummary() {
        if (this.cronEx == null) {
            return null;
        }
        return this.cronEx.getExpressionSummary();
    }

    @Override
    public boolean hasAdditionalProperties() {
        return false;
    }

    @Override
    public ScheduleBuilder<CronTrigger> getScheduleBuilder() {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule(this.getCronExpression()).inTimeZone(this.getTimeZone());
        int n = this.getMisfireInstruction();
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                break;
            }
            case 1: {
                cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
                break;
            }
            case -1: {
                cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                break;
            }
            default: {
                LOGGER.warn("Unrecognized misfire policy {}. Derived builder will use the default cron trigger behavior (MISFIRE_INSTRUCTION_FIRE_ONCE_NOW)", (Object)n);
            }
        }
        return cronScheduleBuilder;
    }

    protected Date getTimeAfter(Date date) {
        if (this.cronEx == null) {
            return null;
        }
        return this.cronEx.getTimeAfter(date);
    }

    protected Date getTimeBefore(Date date) {
        if (this.cronEx == null) {
            return null;
        }
        return this.cronEx.getTimeBefore(date);
    }
}

