/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import java.util.UUID;

public class Key<T>
implements Serializable,
Comparable<Key<T>> {
    private static final long serialVersionUID = -7141167957642391350L;
    public static final String DEFAULT_GROUP = "DEFAULT";
    private final String name;
    private final String group;

    public Key(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        this.name = string;
        if (string2 != null) {
            this.group = string2;
            return;
        }
        this.group = DEFAULT_GROUP;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        return this.getGroup() + '.' + this.getName();
    }

    public int hashCode() {
        int n = 31 + (this.group == null ? 0 : this.group.hashCode());
        n = n * 31 + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Key)object;
        if (this.group == null ? ((Key)object).group != null : !this.group.equals(((Key)object).group)) {
            return false;
        }
        return !(this.name == null ? ((Key)object).name != null : !this.name.equals(((Key)object).name));
    }

    @Override
    public int compareTo(Key<T> key) {
        if (this.group.equals(DEFAULT_GROUP) && !key.group.equals(DEFAULT_GROUP)) {
            return -1;
        }
        if (!this.group.equals(DEFAULT_GROUP) && key.group.equals(DEFAULT_GROUP)) {
            return 1;
        }
        int n = this.group.compareTo(key.getGroup());
        if (n != 0) {
            return n;
        }
        return this.name.compareTo(key.getName());
    }

    public static String createUniqueName(String string) {
        if (string == null) {
            string = DEFAULT_GROUP;
        }
        String string2 = UUID.randomUUID().toString();
        string = UUID.nameUUIDFromBytes(string.getBytes()).toString();
        return String.format("%s-%s", string.substring(24), string2);
    }
}

