/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover$1;
import ch.qos.logback.core.rolling.helper.TimeBasedArchiveRemover;
import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SizeAndTimeBasedArchiveRemover
extends TimeBasedArchiveRemover {
    protected static final int NO_INDEX = -1;

    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        super(fileNamePattern, rollingCalendar);
    }

    @Override
    protected File[] getFilesInPeriod(Instant fileArray) {
        File file = new File(this.fileNamePattern.convertMultipleArguments(fileArray, 0));
        file = this.getParentDir(file);
        fileArray = this.createStemRegex((Instant)fileArray);
        fileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file, (String)fileArray);
        return fileArray;
    }

    private String createStemRegex(Instant object) {
        object = this.fileNamePattern.toRegexForFixedDate((Instant)object);
        return FileFilterUtil.afterLastSlash((String)object);
    }

    @Override
    protected void descendingSort(File[] fileArray, Instant object) {
        object = this.createStemRegex((Instant)object);
        object = Pattern.compile((String)object);
        Arrays.sort(fileArray, new SizeAndTimeBasedArchiveRemover$1(this, (Pattern)object));
    }
}

