/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CalendarComparator;

public class AnnualCalendar
extends BaseCalendar
implements Serializable,
Calendar {
    static final long serialVersionUID = 7346867105876610961L;
    private ArrayList<java.util.Calendar> excludeDays = new ArrayList();
    private boolean dataSorted = false;

    public AnnualCalendar() {
    }

    public AnnualCalendar(Calendar calendar) {
        super(calendar);
    }

    public AnnualCalendar(TimeZone timeZone) {
        super(timeZone);
    }

    public AnnualCalendar(Calendar calendar, TimeZone timeZone) {
        super(calendar, timeZone);
    }

    @Override
    public Object clone() {
        AnnualCalendar annualCalendar = (AnnualCalendar)super.clone();
        ((AnnualCalendar)super.clone()).excludeDays = new ArrayList<java.util.Calendar>(this.excludeDays);
        return annualCalendar;
    }

    public ArrayList<java.util.Calendar> getDaysExcluded() {
        return this.excludeDays;
    }

    public boolean isDayExcluded(java.util.Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Parameter day must not be null");
        }
        if (!super.isTimeIncluded(calendar.getTime().getTime())) {
            return true;
        }
        int n = calendar.get(2);
        int n2 = calendar.get(5);
        if (!this.dataSorted) {
            Collections.sort(this.excludeDays, new CalendarComparator());
            this.dataSorted = true;
        }
        for (java.util.Calendar calendar2 : this.excludeDays) {
            if (n < calendar2.get(2)) {
                return false;
            }
            if (n2 != calendar2.get(5) || n != calendar2.get(2)) continue;
            return true;
        }
        return false;
    }

    public void setDaysExcluded(ArrayList<java.util.Calendar> arrayList) {
        this.excludeDays = arrayList == null ? new ArrayList() : arrayList;
        this.dataSorted = false;
    }

    public void setDayExcluded(java.util.Calendar calendar, boolean bl) {
        if (bl) {
            if (this.isDayExcluded(calendar)) {
                return;
            }
            this.excludeDays.add(calendar);
            this.dataSorted = false;
            return;
        }
        if (!this.isDayExcluded(calendar)) {
            return;
        }
        this.removeExcludedDay(calendar, true);
    }

    public void removeExcludedDay(java.util.Calendar calendar) {
        this.removeExcludedDay(calendar, false);
    }

    private void removeExcludedDay(java.util.Calendar calendar, boolean n) {
        if (n == 0 && !this.isDayExcluded(calendar)) {
            return;
        }
        if (this.excludeDays.remove(calendar)) {
            return;
        }
        n = calendar.get(2);
        int n2 = calendar.get(5);
        for (java.util.Calendar calendar2 : this.excludeDays) {
            if (n != calendar2.get(2) || n2 != calendar2.get(5)) continue;
            calendar = calendar2;
            break;
        }
        this.excludeDays.remove(calendar);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        java.util.Calendar calendar = this.createJavaCalendar(l);
        return !this.isDayExcluded(calendar);
    }

    @Override
    public long getNextIncludedTime(long l) {
        java.util.Calendar calendar;
        long l2 = super.getNextIncludedTime(l);
        if (l2 > 0L && l2 > l) {
            l = l2;
        }
        if (!this.isDayExcluded(calendar = this.getStartOfDayJavaCalendar(l))) {
            return l;
        }
        while (this.isDayExcluded(calendar)) {
            calendar.add(5, 1);
        }
        return calendar.getTime().getTime();
    }
}

