/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesParser {
    Properties props = null;

    public PropertiesParser(Properties properties) {
        this.props = properties;
    }

    public Properties getUnderlyingProperties() {
        return this.props;
    }

    public String getStringProperty(String string) {
        return this.getStringProperty(string, null);
    }

    public String getStringProperty(String string, String string2) {
        if ((string = this.props.getProperty(string, string2)) == null) {
            return string2;
        }
        if ((string = string.trim()).length() == 0) {
            return string2;
        }
        return string;
    }

    public String[] getStringArrayProperty(String string) {
        return this.getStringArrayProperty(string, null);
    }

    public String[] getStringArrayProperty(String object, String[] stringArray) {
        if ((object = this.getStringProperty((String)object)) == null) {
            return stringArray;
        }
        object = new StringTokenizer((String)object, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken().trim());
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2.toArray(new String[arrayList2.size()]);
        }
        catch (Exception exception) {
            return stringArray;
        }
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        if ((string = this.getStringProperty(string)) == null) {
            return bl;
        }
        return Boolean.valueOf(string);
    }

    public byte getByteProperty(String string) {
        if ((string = this.getStringProperty(string)) == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public byte getByteProperty(String string, byte by) {
        if ((string = this.getStringProperty(string)) == null) {
            return by;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public char getCharProperty(String string) {
        return this.getCharProperty(string, '\u0000');
    }

    public char getCharProperty(String string, char c) {
        if ((string = this.getStringProperty(string)) == null) {
            return c;
        }
        return string.charAt(0);
    }

    public double getDoubleProperty(String string) {
        if ((string = this.getStringProperty(string)) == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public double getDoubleProperty(String string, double d) {
        if ((string = this.getStringProperty(string)) == null) {
            return d;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public float getFloatProperty(String string) {
        if ((string = this.getStringProperty(string)) == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public float getFloatProperty(String string, float f) {
        if ((string = this.getStringProperty(string)) == null) {
            return f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public int getIntProperty(String string) {
        if ((string = this.getStringProperty(string)) == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public int getIntProperty(String string, int n) {
        if ((string = this.getStringProperty(string)) == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public int[] getIntArrayProperty(String string) {
        return this.getIntArrayProperty(string, null);
    }

    public int[] getIntArrayProperty(String object, int[] nArray) {
        if ((object = this.getStringProperty((String)object)) == null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    arrayList.add(new Integer(stringTokenizer.nextToken().trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException(" '" + (String)object + "'");
                }
            }
            object = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            return object;
        }
        catch (Exception exception) {
            return nArray;
        }
    }

    public long getLongProperty(String string) {
        if ((string = this.getStringProperty(string)) == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public long getLongProperty(String string, long l) {
        if ((string = this.getStringProperty(string)) == null) {
            return l;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public short getShortProperty(String string) {
        if ((string = this.getStringProperty(string)) == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public short getShortProperty(String string, short s) {
        if ((string = this.getStringProperty(string)) == null) {
            return s;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string + "'");
        }
    }

    public String[] getPropertyGroups(String string) {
        Enumeration<?> enumeration = this.props.propertyNames();
        HashSet<String> hashSet = new HashSet<String>(10);
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            string2 = string2.substring(string.length(), string2.indexOf(46, string.length()));
            hashSet.add(string2);
        }
        HashSet<String> hashSet2 = hashSet;
        return hashSet2.toArray(new String[hashSet2.size()]);
    }

    public Properties getPropertyGroup(String string) {
        return this.getPropertyGroup(string, false, null);
    }

    public Properties getPropertyGroup(String string, boolean bl) {
        return this.getPropertyGroup(string, bl, null);
    }

    public Properties getPropertyGroup(String string, boolean bl, String[] stringArray) {
        Enumeration<?> enumeration = this.props.propertyNames();
        Properties properties = new Properties();
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            boolean bl2 = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length && !bl2; ++i) {
                    bl2 = string2.startsWith(stringArray[i]);
                }
            }
            if (bl2) continue;
            String string3 = this.getStringProperty(string2, "");
            if (bl) {
                properties.put(string2.substring(string.length()), string3);
                continue;
            }
            properties.put(string2, string3);
        }
        return properties;
    }
}

