/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.Arch;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GpuPriority$Companion;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkikoProperties$WhenMappings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b J\u0017\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#H\u0000\u00a2\u0006\u0002\b$R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/skiko/SkikoProperties;", "", "()V", "fpsEnabled", "", "getFpsEnabled", "()Z", "fpsLongFramesMillis", "", "getFpsLongFramesMillis", "()Ljava/lang/Double;", "fpsLongFramesShow", "getFpsLongFramesShow", "fpsPeriodSeconds", "getFpsPeriodSeconds", "()D", "gpuPriority", "Lorg/jetbrains/skiko/GpuPriority;", "getGpuPriority", "()Lorg/jetbrains/skiko/GpuPriority;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "vsyncEnabled", "getVsyncEnabled", "vsyncFramelimitFallbackEnabled", "getVsyncFramelimitFallbackEnabled", "bestRenderApiForCurrentOS", "fallbackRenderApiQueue", "", "initialApi", "fallbackRenderApiQueue$skiko", "parseRenderApi", "text", "", "parseRenderApi$skiko", "skiko"})
public final class SkikoProperties {
    public static final SkikoProperties INSTANCE = new SkikoProperties();

    private SkikoProperties() {
    }

    public final boolean getVsyncEnabled() {
        String string = System.getProperty("skiko.vsync.enabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public final boolean getVsyncFramelimitFallbackEnabled() {
        String string = System.getProperty("skiko.vsync.framelimit.fallback.enabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public final boolean getFpsEnabled() {
        String string = System.getProperty("skiko.fps.enabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public final double getFpsPeriodSeconds() {
        String string = System.getProperty("skiko.fps.periodSeconds");
        if (string != null) {
            return Double.parseDouble(string);
        }
        return 2.0;
    }

    public final boolean getFpsLongFramesShow() {
        String string = System.getProperty("skiko.fps.longFrames.show");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public final Double getFpsLongFramesMillis() {
        String string = System.getProperty("skiko.fps.longFrames.millis");
        if (string != null) {
            return Double.parseDouble(string);
        }
        return null;
    }

    public final GraphicsApi getRenderApi() {
        String string = System.getenv("SKIKO_RENDER_API");
        String string2 = System.getProperty("skiko.renderApi");
        String string3 = string;
        if (string3 == null) {
            string3 = string2;
        }
        return this.parseRenderApi$skiko(string3);
    }

    public final GpuPriority getGpuPriority() {
        Object object;
        block5: {
            block4: {
                String string = System.getProperty("skiko.gpu.priority");
                if (string == null && (string = System.getProperty("skiko.metal.gpu.priority")) == null) {
                    string = System.getProperty("skiko.directx.gpu.priority");
                }
                String string2 = string;
                object = string;
                if (string == null) break block4;
                string2 = object;
                GpuPriority$Companion gpuPriority$Companion = GpuPriority.Companion;
                object = gpuPriority$Companion.parseOrNull(string2);
                if (object != null) break block5;
            }
            object = GpuPriority.Auto;
        }
        return object;
    }

    public final GraphicsApi parseRenderApi$skiko(String string) {
        block28: {
            if (string == null) break block28;
            int n = -1;
            switch (string.hashCode()) {
                case -1019861004: {
                    if (string.equals("SOFTWARE_FAST")) {
                        n = 1;
                    }
                    break;
                }
                case -907020006: {
                    if (string.equals("SOFTWARE_COMPAT")) {
                        n = 2;
                    }
                    break;
                }
                case -1957249873: {
                    if (string.equals("OPENGL")) {
                        n = 3;
                    }
                    break;
                }
                case 1028669466: {
                    if (string.equals("DIRECT3D")) {
                        n = 4;
                    }
                    break;
                }
                case 73249511: {
                    if (string.equals("METAL")) {
                        n = 5;
                    }
                    break;
                }
                case 2101957031: {
                    if (string.equals("SOFTWARE")) {
                        n = 6;
                    }
                    break;
                }
                case 1644349757: {
                    if (string.equals("DIRECT_SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return GraphicsApi.SOFTWARE_COMPAT;
                }
                case 1: {
                    return GraphicsApi.SOFTWARE_FAST;
                }
                case 6: {
                    if (OsArch_jvmKt.getHostOs() == OS.MacOS) {
                        return GraphicsApi.SOFTWARE_COMPAT;
                    }
                    return GraphicsApi.SOFTWARE_FAST;
                }
                case 3: {
                    if (OsArch_jvmKt.getHostOs() != OS.Windows || OsArch_jvmKt.getHostArch() != Arch.Arm64) {
                        return GraphicsApi.OPENGL;
                    }
                    throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + '-' + (Object)((Object)OsArch_jvmKt.getHostArch()) + " does not support OpenGL rendering API.");
                }
                case 4: {
                    if (OsArch_jvmKt.getHostOs() == OS.Windows) {
                        return GraphicsApi.DIRECT3D;
                    }
                    throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support DirectX rendering API.");
                }
                case 5: {
                    if (OsArch_jvmKt.getHostOs() == OS.MacOS) {
                        return GraphicsApi.METAL;
                    }
                    throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support Metal rendering API.");
                }
            }
        }
        return this.bestRenderApiForCurrentOS();
    }

    private final GraphicsApi bestRenderApiForCurrentOS() {
        switch (SkikoProperties$WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 1: {
                return GraphicsApi.METAL;
            }
            case 2: {
                return GraphicsApi.OPENGL;
            }
            case 3: {
                return GraphicsApi.DIRECT3D;
            }
            case 4: {
                return GraphicsApi.OPENGL;
            }
            case 5: 
            case 6: 
            case 7: {
                String string = "commonize me";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final List<GraphicsApi> fallbackRenderApiQueue$skiko(GraphicsApi graphicsApi) {
        List list2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        switch (SkikoProperties$WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 2: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[3];
                object = graphicsApiArray;
                graphicsApiArray[0] = GraphicsApi.OPENGL;
                object[1] = GraphicsApi.SOFTWARE_FAST;
                object[2] = GraphicsApi.SOFTWARE_COMPAT;
                list2 = CollectionsKt.listOf((Object[])object);
                break;
            }
            case 1: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[2];
                object = graphicsApiArray;
                graphicsApiArray[0] = GraphicsApi.METAL;
                object[1] = GraphicsApi.SOFTWARE_COMPAT;
                list2 = CollectionsKt.listOf((Object[])object);
                break;
            }
            case 3: {
                if (SkikoProperties$WhenMappings.$EnumSwitchMapping$1[OsArch_jvmKt.getHostArch().ordinal()] == 1) {
                    GraphicsApi[] graphicsApiArray = new GraphicsApi[3];
                    object = graphicsApiArray;
                    graphicsApiArray[0] = GraphicsApi.DIRECT3D;
                    object[1] = GraphicsApi.SOFTWARE_FAST;
                    object[2] = GraphicsApi.SOFTWARE_COMPAT;
                    list2 = CollectionsKt.listOf((Object[])object);
                    break;
                }
                GraphicsApi[] graphicsApiArray = new GraphicsApi[4];
                object = graphicsApiArray;
                graphicsApiArray[0] = GraphicsApi.DIRECT3D;
                object[1] = GraphicsApi.OPENGL;
                object[2] = GraphicsApi.SOFTWARE_FAST;
                object[3] = GraphicsApi.SOFTWARE_COMPAT;
                list2 = CollectionsKt.listOf((Object[])object);
                break;
            }
            case 4: {
                return CollectionsKt.listOf((Object)((Object)GraphicsApi.OPENGL));
            }
            case 5: 
            case 6: 
            case 7: {
                String string = "commonize me";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        object = list2;
        int n = list2.indexOf((Object)graphicsApi);
        if (!(n >= 0)) {
            object = (Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support " + (Object)((Object)graphicsApi) + " rendering API.";
            throw new IllegalArgumentException(object.toString());
        }
        object = CollectionsKt.drop((Iterable)((Iterable)object), (int)(n + 1));
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)graphicsApi)), (Iterable)((Iterable)object));
    }
}

