/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;

public final class DescriptorUtilKt {
    public static final ClassDescriptor resolveClassByFqName(ModuleDescriptor object, FqName fqName2, LookupLocation lookupLocation) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        if (fqName2.isRoot()) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"");
        MemberScope memberScope2 = object.getPackage(fqName3).getMemberScope();
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        ClassifierDescriptor classifierDescriptor2 = memberScope2.getContributedClassifier(name, lookupLocation);
        if ((classifierDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null) != null) {
            object = classifierDescriptor2;
            return object;
        }
        FqName fqName4 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"");
        classifierDescriptor2 = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)object, fqName4, lookupLocation);
        if (classifierDescriptor2 != null && (object = classifierDescriptor2.getUnsubstitutedInnerClassesScope()) != null) {
            Name name2 = fqName2.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
            classifierDescriptor = object.getContributedClassifier(name2, lookupLocation);
        } else {
            classifierDescriptor = classifierDescriptor2 = null;
        }
        if (classifierDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)classifierDescriptor2;
        }
        return null;
    }

    public static final boolean isTopLevelInPackage(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static final ClassifierDescriptor getTopLevelContainingClassifier(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
        if (declarationDescriptor2 == null || declarationDescriptor instanceof PackageFragmentDescriptor) {
            return null;
        }
        if (!DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor2)) {
            return DescriptorUtilKt.getTopLevelContainingClassifier(declarationDescriptor2);
        }
        if (declarationDescriptor2 instanceof ClassifierDescriptor) {
            return (ClassifierDescriptor)declarationDescriptor2;
        }
        return null;
    }

    public static final boolean isTypedEqualsInValueClass(FunctionDescriptor functionDescriptor) {
        Annotated annotated;
        Annotated annotated2;
        DeclarationDescriptor declarationDescriptor;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
                declarationDescriptor = functionDescriptor.getContainingDeclaration();
                annotated2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                if (annotated2 == null) break block6;
                declarationDescriptor = annotated2;
                annotated = annotated2;
                if ((annotated2 = InlineClassesUtilsKt.isValueClass(annotated2) ? declarationDescriptor : null) != null && (annotated2 = annotated2.getDefaultType()) != null && (annotated2 = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated2)) != null) break block7;
            }
            return false;
        }
        declarationDescriptor = annotated2;
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        annotated = kotlinType;
        if (Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)OperatorNameConventions.EQUALS) && (TypeUtilsKt.isBoolean((KotlinType)annotated) || TypeUtilsKt.isNothing((KotlinType)annotated)) && functionDescriptor.getValueParameters().size() == 1) {
            KotlinType kotlinType2 = functionDescriptor.getValueParameters().get(0).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
            if (Intrinsics.areEqual((Object)TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType2), (Object)declarationDescriptor) && functionDescriptor.getContextReceiverParameters().isEmpty() && functionDescriptor.getExtensionReceiverParameter() == null) {
                return true;
            }
        }
        return false;
    }
}

