/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory$createArrayValue$1;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.TypedArrayValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;

public final class ConstantValueFactory {
    public static final ConstantValueFactory INSTANCE = new ConstantValueFactory();

    private ConstantValueFactory() {
    }

    public final ArrayValue createArrayValue(List<? extends ConstantValue<?>> list, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return new TypedArrayValue(list, kotlinType);
    }

    public final ConstantValue<?> createConstantValue(Object object, ModuleDescriptor moduleDescriptor) {
        Object object2 = object;
        if (object2 instanceof Byte) {
            return new ByteValue(((Number)object).byteValue());
        }
        if (object2 instanceof Short) {
            return new ShortValue(((Number)object).shortValue());
        }
        if (object2 instanceof Integer) {
            return new IntValue(((Number)object).intValue());
        }
        if (object2 instanceof Long) {
            return new LongValue(((Number)object).longValue());
        }
        if (object2 instanceof Character) {
            return new CharValue(((Character)object).charValue());
        }
        if (object2 instanceof Float) {
            return new FloatValue(((Number)object).floatValue());
        }
        if (object2 instanceof Double) {
            return new DoubleValue(((Number)object).doubleValue());
        }
        if (object2 instanceof Boolean) {
            return new BooleanValue((Boolean)object);
        }
        if (object2 instanceof String) {
            return new StringValue((String)object);
        }
        if (object2 instanceof byte[]) {
            return this.createArrayValue(ArraysKt.toList((byte[])((byte[])object)), moduleDescriptor, PrimitiveType.BYTE);
        }
        if (object2 instanceof short[]) {
            return this.createArrayValue(ArraysKt.toList((short[])((short[])object)), moduleDescriptor, PrimitiveType.SHORT);
        }
        if (object2 instanceof int[]) {
            return this.createArrayValue(ArraysKt.toList((int[])((int[])object)), moduleDescriptor, PrimitiveType.INT);
        }
        if (object2 instanceof long[]) {
            return this.createArrayValue(ArraysKt.toList((long[])((long[])object)), moduleDescriptor, PrimitiveType.LONG);
        }
        if (object2 instanceof char[]) {
            return this.createArrayValue(ArraysKt.toList((char[])((char[])object)), moduleDescriptor, PrimitiveType.CHAR);
        }
        if (object2 instanceof float[]) {
            return this.createArrayValue(ArraysKt.toList((float[])((float[])object)), moduleDescriptor, PrimitiveType.FLOAT);
        }
        if (object2 instanceof double[]) {
            return this.createArrayValue(ArraysKt.toList((double[])((double[])object)), moduleDescriptor, PrimitiveType.DOUBLE);
        }
        if (object2 instanceof boolean[]) {
            return this.createArrayValue(ArraysKt.toList((boolean[])((boolean[])object)), moduleDescriptor, PrimitiveType.BOOLEAN);
        }
        if (object2 == null) {
            return new NullValue();
        }
        return null;
    }

    public static /* synthetic */ ConstantValue createConstantValue$default(ConstantValueFactory constantValueFactory, Object object, ModuleDescriptor moduleDescriptor, int n, Object object2) {
        if ((n & 2) != 0) {
            moduleDescriptor = null;
        }
        return constantValueFactory.createConstantValue(object, moduleDescriptor);
    }

    private final ArrayValue createArrayValue(List<?> object, ModuleDescriptor moduleDescriptor, PrimitiveType primitiveType) {
        object = CollectionsKt.toList((Iterable)((Iterable)object));
        Collection collection = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            Object object2 = e;
            object2 = e;
            object2 = e;
            ConstantValue constantValue = ConstantValueFactory.createConstantValue$default(this, object2, null, 2, null);
            if (constantValue == null) continue;
            object2 = constantValue;
            collection.add(object2);
        }
        object = (List)collection;
        if (moduleDescriptor != null) {
            SimpleType simpleType2 = moduleDescriptor.getBuiltIns().getPrimitiveArrayKotlinType(primitiveType);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
            return new TypedArrayValue((List<? extends ConstantValue<?>>)object, simpleType2);
        }
        return new ArrayValue((List<? extends ConstantValue<?>>)object, (Function1<? super ModuleDescriptor, ? extends KotlinType>)((Function1)new ConstantValueFactory$createArrayValue$1(primitiveType)));
    }
}

