/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.platform.DesktopWindow;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.WindowUtils$HeavyweightForcer;
import com.sun.jna.platform.WindowUtils$Holder;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$2;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$3;
import com.sun.jna.platform.win32.WinDef;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class WindowUtils$NativeWindowUtils {
    protected Window getWindow(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    protected void whenDisplayable(Component component, Runnable runnable) {
        if (component.isDisplayable() && (!WindowUtils$Holder.requiresVisible || component.isVisible())) {
            runnable.run();
            return;
        }
        if (WindowUtils$Holder.requiresVisible) {
            this.getWindow(component).addWindowListener(new WindowUtils$NativeWindowUtils$1(this, runnable));
            return;
        }
        component.addHierarchyListener(new WindowUtils$NativeWindowUtils$2(this, runnable));
    }

    protected Raster toRaster(Shape shape) {
        Object object = null;
        if (shape != WindowUtils.MASK_NONE) {
            Rectangle rectangle = shape.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                object = new BufferedImage(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 12);
                Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, 0, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics2D.setColor(Color.white);
                graphics2D.fill(shape);
                object = ((BufferedImage)object).getRaster();
            }
        }
        return object;
    }

    protected Raster toRaster(Component component, Icon icon) {
        Object object = null;
        if (icon != null) {
            object = new Rectangle(0, 0, icon.getIconWidth(), icon.getIconHeight());
            BufferedImage bufferedImage = new BufferedImage(((Rectangle)object).width, ((Rectangle)object).height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            icon.paintIcon(component, graphics2D, 0, 0);
            object = bufferedImage.getAlphaRaster();
        }
        return object;
    }

    protected Shape toShape(Raster raster) {
        Area area = new Area(new Rectangle(0, 0, 0, 0));
        RasterRangesUtils.outputOccupiedRanges(raster, new WindowUtils$NativeWindowUtils$3(this, area));
        return area;
    }

    public void setWindowAlpha(Window window, float f) {
    }

    public boolean isWindowAlphaSupported() {
        return false;
    }

    public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        object = ((GraphicsEnvironment)object).getDefaultScreenDevice();
        return ((GraphicsDevice)object).getDefaultConfiguration();
    }

    public void setWindowTransparent(Window window, boolean bl) {
    }

    protected void setDoubleBuffered(Component componentArray, boolean bl) {
        if (componentArray instanceof JComponent) {
            ((JComponent)componentArray).setDoubleBuffered(bl);
        }
        if (componentArray instanceof JRootPane && bl) {
            ((JRootPane)componentArray).setDoubleBuffered(true);
            return;
        }
        if (componentArray instanceof Container) {
            componentArray = ((Container)componentArray).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.setDoubleBuffered(componentArray[i], bl);
            }
        }
    }

    protected void setLayersTransparent(Window window, boolean bl) {
        Color color;
        Color color2 = color = bl ? new Color(0, 0, 0, 0) : null;
        if (window instanceof RootPaneContainer) {
            Object object = (RootPaneContainer)((Object)window);
            object = object.getRootPane();
            JLayeredPane jLayeredPane = ((JRootPane)object).getLayeredPane();
            Container container = ((JRootPane)object).getContentPane();
            Container container2 = container = container instanceof JComponent ? (JComponent)container : null;
            if (bl) {
                jLayeredPane.putClientProperty("transparent-old-opaque", jLayeredPane.isOpaque());
                jLayeredPane.setOpaque(false);
                ((JComponent)object).putClientProperty("transparent-old-opaque", ((JComponent)object).isOpaque());
                ((JComponent)object).setOpaque(false);
                if (container != null) {
                    ((JComponent)container).putClientProperty("transparent-old-opaque", ((JComponent)container).isOpaque());
                    ((JComponent)container).setOpaque(false);
                }
                ((JComponent)object).putClientProperty("transparent-old-bg", ((Component)object).getParent().getBackground());
            } else {
                jLayeredPane.setOpaque(Boolean.TRUE.equals(jLayeredPane.getClientProperty("transparent-old-opaque")));
                jLayeredPane.putClientProperty("transparent-old-opaque", null);
                ((JComponent)object).setOpaque(Boolean.TRUE.equals(((JComponent)object).getClientProperty("transparent-old-opaque")));
                ((JComponent)object).putClientProperty("transparent-old-opaque", null);
                if (container != null) {
                    ((JComponent)container).setOpaque(Boolean.TRUE.equals(((JComponent)container).getClientProperty("transparent-old-opaque")));
                    ((JComponent)container).putClientProperty("transparent-old-opaque", null);
                }
                color = (Color)((JComponent)object).getClientProperty("transparent-old-bg");
                ((JComponent)object).putClientProperty("transparent-old-bg", null);
            }
        }
        window.setBackground(color);
    }

    protected void setMask(Component component, Raster raster) {
        throw new UnsupportedOperationException("Window masking is not available");
    }

    protected void setWindowMask(Component component, Raster raster) {
        if (component.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight: " + component);
        }
        this.setMask(component, raster);
    }

    public void setWindowMask(Component component, Shape shape) {
        this.setWindowMask(component, this.toRaster(shape));
    }

    public void setWindowMask(Component component, Icon icon) {
        this.setWindowMask(component, this.toRaster(component, icon));
    }

    protected void setForceHeavyweightPopups(Window window, boolean bl) {
        if (!(window instanceof WindowUtils$HeavyweightForcer)) {
            Window[] windowArray = window.getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                if (!(windowArray[i] instanceof WindowUtils$HeavyweightForcer)) continue;
                if (bl) {
                    return;
                }
                windowArray[i].dispose();
            }
            Boolean bl2 = Boolean.valueOf(System.getProperty("jna.force_hw_popups", "true"));
            if (bl && bl2.booleanValue()) {
                new WindowUtils$HeavyweightForcer(window);
            }
        }
    }

    protected BufferedImage getWindowIcon(WinDef.HWND hWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected Dimension getIconSize(WinDef.HICON hICON) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected List<DesktopWindow> getAllWindows(boolean bl) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected String getWindowTitle(WinDef.HWND hWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected String getProcessFilePath(WinDef.HWND hWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected Rectangle getWindowLocationAndSize(WinDef.HWND hWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }
}

