/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$1;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$2;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$3;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$4;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$5;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$PixmapSource;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.platform.unix.X11$GC;
import com.sun.jna.platform.unix.X11$Pixmap;
import com.sun.jna.platform.unix.X11$Window;
import com.sun.jna.platform.unix.X11$WindowByReference;
import com.sun.jna.platform.unix.X11$XRectangle;
import com.sun.jna.platform.unix.X11$XVisualInfo;
import com.sun.jna.platform.unix.X11$XWindowAttributes;
import com.sun.jna.platform.unix.X11$Xrender;
import com.sun.jna.platform.unix.X11$Xrender$XRenderPictFormat;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.Raster;
import java.util.ArrayList;
import javax.swing.RootPaneContainer;

class WindowUtils$X11WindowUtils
extends WindowUtils$NativeWindowUtils {
    private boolean didCheck;
    private long[] alphaVisualIDs = new long[0];
    private static final long OPAQUE = 0xFFFFFFFFL;
    private static final String OPACITY = "_NET_WM_WINDOW_OPACITY";

    private WindowUtils$X11WindowUtils() {
    }

    private static X11$Pixmap createBitmap(X11.Display display, X11$Window x11$Drawable, Raster x11$XRectangleArray) {
        X11 x11 = X11.INSTANCE;
        Rectangle rectangle = x11$XRectangleArray.getBounds();
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        X11$GC x11$GC = x11.XCreateGC(display, x11$Drawable = x11.XCreatePixmap(display, x11$Drawable, n, n2, 1), new NativeLong(0L), null);
        if (x11$GC == null) {
            return null;
        }
        x11.XSetForeground(display, x11$GC, new NativeLong(0L));
        x11.XFillRectangle(display, x11$Drawable, x11$GC, 0, 0, n, n2);
        ArrayList arrayList = new ArrayList();
        try {
            RasterRangesUtils.outputOccupiedRanges((Raster)x11$XRectangleArray, new WindowUtils$X11WindowUtils$1(arrayList));
            x11$XRectangleArray = (X11$XRectangle[])new X11$XRectangle().toArray(arrayList.size());
            for (n = 0; n < x11$XRectangleArray.length; ++n) {
                Rectangle rectangle2 = (Rectangle)arrayList.get(n);
                x11$XRectangleArray[n].x = (short)rectangle2.x;
                x11$XRectangleArray[n].y = (short)rectangle2.y;
                x11$XRectangleArray[n].width = (short)rectangle2.width;
                x11$XRectangleArray[n].height = (short)rectangle2.height;
                Pointer pointer = x11$XRectangleArray[n].getPointer();
                pointer.setShort(0L, (short)rectangle2.x);
                pointer.setShort(2L, (short)rectangle2.y);
                pointer.setShort(4L, (short)rectangle2.width);
                pointer.setShort(6L, (short)rectangle2.height);
                x11$XRectangleArray[n].setAutoSynch(false);
            }
            x11.XSetForeground(display, x11$GC, new NativeLong(1L));
            x11.XFillRectangles(display, x11$Drawable, x11$GC, x11$XRectangleArray, x11$XRectangleArray.length);
        }
        finally {
            x11.XFreeGC(display, x11$GC);
        }
        return x11$Drawable;
    }

    @Override
    public boolean isWindowAlphaSupported() {
        return this.getAlphaVisualIDs().length > 0;
    }

    private static long getVisualID(GraphicsConfiguration object) {
        try {
            object = object.getClass().getMethod("getVisual", null).invoke(object, (Object[])null);
            return ((Number)object).longValue();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return -1L;
        }
    }

    @Override
    public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        if (this.isWindowAlphaSupported()) {
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsDeviceArray = graphicsDeviceArray.getScreenDevices();
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
                for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                    long l = WindowUtils$X11WindowUtils.getVisualID(graphicsConfigurationArray[j]);
                    long[] lArray = this.getAlphaVisualIDs();
                    for (int k = 0; k < lArray.length; ++k) {
                        if (l != lArray[k]) continue;
                        return graphicsConfigurationArray[j];
                    }
                }
            }
        }
        return super.getAlphaCompatibleGraphicsConfiguration();
    }

    private synchronized long[] getAlphaVisualIDs() {
        if (this.didCheck) {
            return this.alphaVisualIDs;
        }
        this.didCheck = true;
        X11 x11 = X11.INSTANCE;
        X11.Display display = x11.XOpenDisplay(null);
        if (display == null) {
            return this.alphaVisualIDs;
        }
        X11$XVisualInfo x11$XVisualInfo = null;
        try {
            int n = x11.XDefaultScreen(display);
            X11$XVisualInfo[] x11$XVisualInfoArray = new X11$XVisualInfo();
            new X11$XVisualInfo().screen = n;
            x11$XVisualInfoArray.depth = 32;
            x11$XVisualInfoArray.c_class = 4;
            Object object = new NativeLong(14L);
            IntByReference intByReference = new IntByReference();
            x11$XVisualInfo = x11.XGetVisualInfo(display, (NativeLong)object, (X11$XVisualInfo)x11$XVisualInfoArray, intByReference);
            if (x11$XVisualInfo != null) {
                int n2;
                object = new ArrayList();
                x11$XVisualInfoArray = (X11$XVisualInfo[])x11$XVisualInfo.toArray(intByReference.getValue());
                for (n2 = 0; n2 < x11$XVisualInfoArray.length; ++n2) {
                    X11$Xrender$XRenderPictFormat x11$Xrender$XRenderPictFormat = X11$Xrender.INSTANCE.XRenderFindVisualFormat(display, x11$XVisualInfoArray[n2].visual);
                    if (x11$Xrender$XRenderPictFormat.type != 1 || x11$Xrender$XRenderPictFormat.direct.alphaMask == 0) continue;
                    object.add(x11$XVisualInfoArray[n2].visualid);
                }
                this.alphaVisualIDs = new long[object.size()];
                for (n2 = 0; n2 < this.alphaVisualIDs.length; ++n2) {
                    this.alphaVisualIDs[n2] = ((Number)object.get(n2)).longValue();
                }
                long[] lArray = this.alphaVisualIDs;
                return lArray;
            }
        }
        finally {
            if (x11$XVisualInfo != null) {
                x11.XFree(x11$XVisualInfo.getPointer());
            }
            x11.XCloseDisplay(display);
        }
        return this.alphaVisualIDs;
    }

    private static X11$Window getContentWindow(Window object, X11.Display display, X11$Window x11$Window, Point point) {
        if (object instanceof Frame && !((Frame)object).isUndecorated() || object instanceof Dialog && !((Dialog)object).isUndecorated()) {
            object = X11.INSTANCE;
            X11$WindowByReference x11$WindowByReference = new X11$WindowByReference();
            Object object2 = new X11$WindowByReference();
            PointerByReference pointerByReference = new PointerByReference();
            IntByReference intByReference = new IntByReference();
            object.XQueryTree(display, x11$Window, x11$WindowByReference, (X11$WindowByReference)((Object)object2), pointerByReference, intByReference);
            x11$WindowByReference = pointerByReference.getValue();
            int[] nArray = x11$WindowByReference.getIntArray(0L, intByReference.getValue());
            object2 = nArray;
            object2 = nArray;
            int n = nArray.length;
            if (n > 0) {
                X11$WindowByReference x11$WindowByReference2 = object2[0];
                x11$Window = new X11$Window((long)x11$WindowByReference2);
                object2 = new X11$XWindowAttributes();
                object.XGetWindowAttributes(display, x11$Window, (X11$XWindowAttributes)((Object)object2));
                point.x = -((X11$XWindowAttributes)((Object)object2)).x;
                point.y = -((X11$XWindowAttributes)((Object)object2)).y;
            }
            if (x11$WindowByReference != null) {
                object.XFree((Pointer)x11$WindowByReference);
            }
        }
        return x11$Window;
    }

    private static X11$Window getDrawable(Component component) {
        int n = (int)Native.getComponentID((Component)component);
        if (n == 0) {
            return null;
        }
        return new X11$Window(n);
    }

    @Override
    public void setWindowAlpha(Window window, float f) {
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
        }
        WindowUtils$X11WindowUtils$2 windowUtils$X11WindowUtils$2 = new WindowUtils$X11WindowUtils$2(this, window, f);
        this.whenDisplayable(window, windowUtils$X11WindowUtils$2);
    }

    @Override
    public void setWindowTransparent(Window window, boolean bl) {
        boolean bl2;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window must be a RootPaneContainer");
        }
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
        }
        if (!window.getGraphicsConfiguration().equals(this.getAlphaCompatibleGraphicsConfiguration())) {
            throw new IllegalArgumentException("Window GraphicsConfiguration '" + window.getGraphicsConfiguration() + "' does not support transparency");
        }
        boolean bl3 = bl2 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
        if (bl == bl2) {
            return;
        }
        this.whenDisplayable(window, new WindowUtils$X11WindowUtils$3(this, window, bl));
    }

    private void setWindowShape(Window window, WindowUtils$X11WindowUtils$PixmapSource object) {
        object = new WindowUtils$X11WindowUtils$4(this, window, (WindowUtils$X11WindowUtils$PixmapSource)object);
        this.whenDisplayable(window, (Runnable)object);
    }

    @Override
    protected void setMask(Component component, Raster raster) {
        WindowUtils$X11WindowUtils windowUtils$X11WindowUtils = this;
        windowUtils$X11WindowUtils.setWindowShape(windowUtils$X11WindowUtils.getWindow(component), new WindowUtils$X11WindowUtils$5(this, raster));
    }

    /* synthetic */ WindowUtils$X11WindowUtils(WindowUtils$1 windowUtils$1) {
        this();
    }

    static /* synthetic */ X11$Window access$900(Component component) {
        return WindowUtils$X11WindowUtils.getDrawable(component);
    }

    static /* synthetic */ X11$Window access$1000(Window window, X11.Display display, X11$Window x11$Window, Point point) {
        return WindowUtils$X11WindowUtils.getContentWindow(window, display, x11$Window, point);
    }

    static /* synthetic */ X11$Pixmap access$1100(X11.Display display, X11$Window x11$Window, Raster raster) {
        return WindowUtils$X11WindowUtils.createBitmap(display, x11$Window, raster);
    }
}

