/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CodespaceRange;

public class CMap {
    private static final Log LOG = LogFactory.getLog(CMap.class);
    private int wmode = 0;
    private String cmapName = null;
    private String cmapVersion = null;
    private int cmapType = -1;
    private String registry = null;
    private String ordering = null;
    private int supplement = 0;
    private int minCodeLength = 4;
    private int maxCodeLength;
    private int minCidLength = 4;
    private int maxCidLength = 0;
    private final List<CodespaceRange> codespaceRanges = new ArrayList<CodespaceRange>();
    private final Map<Integer, String> charToUnicodeOneByte = new HashMap<Integer, String>();
    private final Map<Integer, String> charToUnicodeTwoBytes = new HashMap<Integer, String>();
    private final Map<Integer, Map<Integer, Integer>> codeToCid = new HashMap<Integer, Map<Integer, Integer>>();
    private final List<CIDRange> codeToCidRanges = new ArrayList<CIDRange>();
    private final Map<String, byte[]> unicodeToByteCodes = new HashMap<String, byte[]>();
    private static final String SPACE = " ";
    private int spaceMapping = -1;

    CMap() {
    }

    public boolean hasCIDMappings() {
        return !this.codeToCid.isEmpty() || !this.codeToCidRanges.isEmpty();
    }

    public boolean hasUnicodeMappings() {
        return !this.charToUnicodeOneByte.isEmpty() || !this.charToUnicodeTwoBytes.isEmpty();
    }

    public String toUnicode(int n) {
        String string = n < 256 ? this.toUnicode(n, 1) : null;
        if (string == null) {
            string = this.toUnicode(n, 2);
        }
        return string;
    }

    public String toUnicode(int n, int n2) {
        if (n2 == 1) {
            return this.charToUnicodeOneByte.get(n);
        }
        if (n2 == 2) {
            return this.charToUnicodeTwoBytes.get(n);
        }
        LOG.warn((Object)"Mappings with more than 2 bytes aren't supported");
        return null;
    }

    public String toUnicode(byte[] byArray) {
        return this.toUnicode(CMap.toInt(byArray), byArray.length);
    }

    public int readCode(InputStream inputStream) {
        int n;
        byte[] byArray = new byte[this.maxCodeLength];
        inputStream.read(byArray, 0, this.minCodeLength);
        inputStream.mark(this.maxCodeLength);
        for (int i = this.minCodeLength - 1; i < this.maxCodeLength; ++i) {
            n = i + 1;
            if (this.codespaceRanges.stream().anyMatch(codespaceRange -> codespaceRange.isFullMatch(byArray, n))) {
                return CMap.toInt(byArray, n);
            }
            if (n >= this.maxCodeLength) continue;
            byArray[n] = (byte)inputStream.read();
        }
        if (LOG.isWarnEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < this.maxCodeLength; ++n) {
                stringBuilder.append(String.format("0x%02X (%04o) ", byArray[n], byArray[n]));
            }
            LOG.warn((Object)("Invalid character code sequence " + stringBuilder + "in CMap " + this.cmapName));
        }
        if (inputStream.markSupported()) {
            inputStream.reset();
        } else {
            LOG.warn((Object)("mark() and reset() not supported, " + (this.maxCodeLength - 1) + " bytes have been skipped"));
        }
        return CMap.toInt(byArray, this.minCodeLength);
    }

    static int toInt(byte[] byArray) {
        return CMap.toInt(byArray, byArray.length);
    }

    private static int toInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 8;
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    public int toCID(byte[] byArray) {
        if (!this.hasCIDMappings() || byArray.length < this.minCidLength || byArray.length > this.maxCidLength) {
            return 0;
        }
        Integer n = null;
        if (this.codeToCid.containsKey(byArray.length)) {
            n = this.codeToCid.get(byArray.length).get(CMap.toInt(byArray));
        }
        if (n == null) {
            n = this.toCIDFromRanges(byArray);
        }
        return n;
    }

    public int toCID(int n) {
        if (!this.hasCIDMappings()) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.minCidLength;
        while (n2 == 0 && n3 <= this.maxCidLength) {
            n2 = this.toCID(n, n3++);
        }
        return n2;
    }

    public int toCID(int n, int n2) {
        if (!this.hasCIDMappings() || n2 < this.minCidLength || n2 > this.maxCidLength) {
            return 0;
        }
        Integer n3 = null;
        if (this.codeToCid.containsKey(n2)) {
            n3 = this.codeToCid.get(n2).get(n);
        }
        if (n3 != null) {
            return n3;
        }
        return this.toCIDFromRanges(n, n2);
    }

    private int toCIDFromRanges(int n, int n2) {
        for (CIDRange cIDRange : this.codeToCidRanges) {
            int n3 = cIDRange.map(n, n2);
            if (n3 == -1) continue;
            return n3;
        }
        return 0;
    }

    private int toCIDFromRanges(byte[] byArray) {
        for (CIDRange cIDRange : this.codeToCidRanges) {
            int n = cIDRange.map(byArray);
            if (n == -1) continue;
            return n;
        }
        return 0;
    }

    private int getCodeFromArray(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= (byArray[n + i] + 256) % 256;
        }
        return n3;
    }

    void addCharMapping(byte[] byArray, String string) {
        this.unicodeToByteCodes.put(string, (byte[])byArray.clone());
        int n = this.getCodeFromArray(byArray, 0, byArray.length);
        if (byArray.length == 1) {
            this.charToUnicodeOneByte.put(n, string);
        } else if (byArray.length == 2) {
            this.charToUnicodeTwoBytes.put(n, string);
        } else {
            LOG.warn((Object)"Mappings with more than 2 bytes aren't supported yet");
        }
        if (SPACE.equals(string)) {
            this.spaceMapping = n;
        }
    }

    public byte[] getCodesFromUnicode(String string) {
        return this.unicodeToByteCodes.get(string);
    }

    void addCIDMapping(byte[] byArray, int n) {
        Map<Integer, Integer> map = this.codeToCid.get(byArray.length);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this.codeToCid.put(byArray.length, map);
            this.minCidLength = Math.min(this.minCidLength, byArray.length);
            this.maxCidLength = Math.max(this.maxCidLength, byArray.length);
        }
        map.put(CMap.toInt(byArray), n);
    }

    void addCIDRange(byte[] byArray, byte[] byArray2, int n) {
        CMap cMap = this;
        cMap.addCIDRange(cMap.codeToCidRanges, CMap.toInt(byArray), CMap.toInt(byArray2), n, byArray.length);
    }

    private void addCIDRange(List<CIDRange> list, int n, int n2, int n3, int n4) {
        CIDRange cIDRange = null;
        if (!list.isEmpty()) {
            List<CIDRange> list2 = list;
            cIDRange = list2.get(list2.size() - 1);
        }
        if (cIDRange == null || !cIDRange.extend(n, n2, n3, n4)) {
            list.add(new CIDRange(n, n2, n3, n4));
            this.minCidLength = Math.min(this.minCidLength, n4);
            this.maxCidLength = Math.max(this.maxCidLength, n4);
        }
    }

    void addCodespaceRange(CodespaceRange codespaceRange) {
        this.codespaceRanges.add(codespaceRange);
        this.maxCodeLength = Math.max(this.maxCodeLength, codespaceRange.getCodeLength());
        this.minCodeLength = Math.min(this.minCodeLength, codespaceRange.getCodeLength());
    }

    void useCmap(CMap cMap) {
        cMap.codespaceRanges.forEach(this::addCodespaceRange);
        this.charToUnicodeOneByte.putAll(cMap.charToUnicodeOneByte);
        this.charToUnicodeTwoBytes.putAll(cMap.charToUnicodeTwoBytes);
        cMap.charToUnicodeOneByte.forEach((n, string) -> this.unicodeToByteCodes.put((String)string, new byte[]{(byte)(n % 255)}));
        cMap.charToUnicodeTwoBytes.forEach((n, string) -> this.unicodeToByteCodes.put((String)string, new byte[]{(byte)(n >>> 8), (byte)n.intValue()}));
        cMap.codeToCid.forEach((object, map) -> {
            if ((object = this.codeToCid.putIfAbsent((Integer)object, (Map<Integer, Integer>)map)) != null) {
                object.putAll(map);
            }
        });
        this.codeToCidRanges.addAll(cMap.codeToCidRanges);
        this.maxCodeLength = Math.max(this.maxCodeLength, cMap.maxCodeLength);
        this.minCodeLength = Math.min(this.minCodeLength, cMap.minCodeLength);
        this.maxCidLength = Math.max(this.maxCidLength, cMap.maxCidLength);
        this.minCidLength = Math.min(this.minCidLength, cMap.minCidLength);
    }

    public int getWMode() {
        return this.wmode;
    }

    public void setWMode(int n) {
        this.wmode = n;
    }

    public String getName() {
        return this.cmapName;
    }

    public void setName(String string) {
        this.cmapName = string;
    }

    public String getVersion() {
        return this.cmapVersion;
    }

    public void setVersion(String string) {
        this.cmapVersion = string;
    }

    public int getType() {
        return this.cmapType;
    }

    public void setType(int n) {
        this.cmapType = n;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String string) {
        this.registry = string;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String string) {
        this.ordering = string;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int n) {
        this.supplement = n;
    }

    public int getSpaceMapping() {
        return this.spaceMapping;
    }

    public String toString() {
        return this.cmapName;
    }
}

