/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TrueTypeFont;

public class NameRecord {
    public static final int PLATFORM_UNICODE = 0;
    public static final int PLATFORM_MACINTOSH = 1;
    public static final int PLATFORM_ISO = 2;
    public static final int PLATFORM_WINDOWS = 3;
    public static final int ENCODING_UNICODE_1_0 = 0;
    public static final int ENCODING_UNICODE_1_1 = 1;
    public static final int ENCODING_UNICODE_2_0_BMP = 3;
    public static final int ENCODING_UNICODE_2_0_FULL = 4;
    public static final int LANGUAGE_UNICODE = 0;
    public static final int ENCODING_WINDOWS_SYMBOL = 0;
    public static final int ENCODING_WINDOWS_UNICODE_BMP = 1;
    public static final int ENCODING_WINDOWS_UNICODE_UCS4 = 10;
    public static final int LANGUAGE_WINDOWS_EN_US = 1033;
    public static final int ENCODING_MACINTOSH_ROMAN = 0;
    public static final int LANGUAGE_MACINTOSH_ENGLISH = 0;
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FONT_FAMILY_NAME = 1;
    public static final int NAME_FONT_SUB_FAMILY_NAME = 2;
    public static final int NAME_UNIQUE_FONT_ID = 3;
    public static final int NAME_FULL_FONT_NAME = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_POSTSCRIPT_NAME = 6;
    public static final int NAME_TRADEMARK = 7;
    private int platformId;
    private int platformEncodingId;
    private int languageId;
    private int nameId;
    private int stringLength;
    private int stringOffset;
    private String string;

    public int getStringLength() {
        return this.stringLength;
    }

    public void setStringLength(int n) {
        this.stringLength = n;
    }

    public int getStringOffset() {
        return this.stringOffset;
    }

    public void setStringOffset(int n) {
        this.stringOffset = n;
    }

    public int getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(int n) {
        this.languageId = n;
    }

    public int getNameId() {
        return this.nameId;
    }

    public void setNameId(int n) {
        this.nameId = n;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int n) {
        this.platformEncodingId = n;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int n) {
        this.platformId = n;
    }

    void initData(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        this.platformId = tTFDataStream.readUnsignedShort();
        this.platformEncodingId = tTFDataStream.readUnsignedShort();
        this.languageId = tTFDataStream.readUnsignedShort();
        this.nameId = tTFDataStream.readUnsignedShort();
        this.stringLength = tTFDataStream.readUnsignedShort();
        this.stringOffset = tTFDataStream.readUnsignedShort();
    }

    public String toString() {
        return "platform=" + this.platformId + " pEncoding=" + this.platformEncodingId + " language=" + this.languageId + " name=" + this.nameId + " " + this.string;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }
}

