/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompoundCharacterTokenizer {
    private final Pattern regexExpression;

    public CompoundCharacterTokenizer(Set<String> set) {
        this.regexExpression = Pattern.compile(this.getRegexFromTokens(set));
    }

    public CompoundCharacterTokenizer(String string) {
        this.regexExpression = Pattern.compile(string);
    }

    public List<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.regexExpression.matcher(string);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            String string2 = string.substring(n, n2);
            if (string2.length() > 0) {
                arrayList.add(string2);
            }
            string2 = matcher.group();
            arrayList.add(string2);
            n = matcher.end();
        }
        String string3 = string.substring(n);
        if (string3.length() > 0) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String getRegexFromTokens(Set<String> set) {
        StringJoiner stringJoiner = new StringJoiner(")|(", "(", ")");
        set.forEach(stringJoiner::add);
        return stringJoiner.toString();
    }
}

