/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.awt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.InternalSunApiChecker;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.ReflectionUtil;
import org.jetbrains.skiko.awt.font.AwtFontUtils$Font2DHandle_font2DField$1;
import org.jetbrains.skiko.awt.font.AwtFontUtils$Font2D_handleField$1;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001H\u0002J\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020'J3\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\u001e2\u001a\u0010*\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040+\"\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u0004\u0018\u00010\u001e2\u0006\u0010.\u001a\u00020\u001e2\b\b\u0002\u0010/\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b0J\f\u00101\u001a\u00020\u0001*\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u0004\u0018\u00010\u001e*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u00062"}, d2={"Lorg/jetbrains/skiko/awt/font/AwtFontUtils;", "", "()V", "CFontClass", "Ljava/lang/Class;", "CompositeFontClass", "kotlin.jvm.PlatformType", "CompositeFont_getSlotFontMethod", "Ljava/lang/reflect/Method;", "FileFontClass", "FileFont_getPublicFileNameMethod", "Font2DClass", "Font2DHandle_font2DField", "Ljava/lang/reflect/Field;", "Font2D_getFamilyNameMethod", "Font2D_getTypographicFamilyNameMethod", "Font2D_handleField", "FontManagerClass", "FontManagerFactoryClass", "FontManagerFactory_getInstanceMethod", "FontManager_findFont2DMethod", "LOGICAL_FALLBACK", "", "font2DHandlesCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/awt/Font;", "isAbleToResolveFontProperties", "", "()Z", "fontFamilyName", "", "getFontFamilyName", "(Ljava/awt/Font;)Ljava/lang/String;", "fontFileName", "getFontFileName", "awtFontManager", "fontFamilyNamesOrNull", "Ljava/util/SortedSet;", "graphicsEnvironment", "Ljava/awt/GraphicsEnvironment;", "getFont2DMethodOrNull", "methodName", "parameters", "", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "resolvePhysicalFontNameOrNull", "fontName", "style", "resolvePhysicalFontNameOrNull$skiko", "obtainFont2D", "skiko"})
public final class AwtFontUtils {
    public static final AwtFontUtils INSTANCE = new AwtFontUtils();
    private static final Class<?> FontManagerFactoryClass;
    private static final Class<?> FontManagerClass;
    private static final Class<?> Font2DClass;
    private static final Class<?> FileFontClass;
    private static final Class<?> CompositeFontClass;
    private static final Class<?> CFontClass;
    private static final Method FontManagerFactory_getInstanceMethod;
    private static final Method FontManager_findFont2DMethod;
    private static final Method Font2D_getTypographicFamilyNameMethod;
    private static final Method Font2D_getFamilyNameMethod;
    private static final Field Font2D_handleField;
    private static final Field Font2DHandle_font2DField;
    private static final Method FileFont_getPublicFileNameMethod;
    private static final Method CompositeFont_getSlotFontMethod;
    private static final int LOGICAL_FALLBACK = 2;
    private static final ConcurrentHashMap<Font, Object> font2DHandlesCache;

    private AwtFontUtils() {
    }

    public final boolean isAbleToResolveFontProperties() {
        return Font2D_getTypographicFamilyNameMethod != null;
    }

    public final String resolvePhysicalFontNameOrNull$skiko(String object, int n) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        Object object2 = this.awtFontManager();
        Method method = FontManager_findFont2DMethod;
        if (method == null) {
            object = "FontManager#findFont2DMethod() is not available";
            throw new IllegalStateException(object.toString());
        }
        Object[] objectArray = object2;
        Object[] objectArray2 = new Object[3];
        object2 = objectArray2;
        objectArray2[0] = object;
        object2[1] = n;
        object2[2] = 2;
        object = method.invoke((Object)objectArray, object2);
        if (CompositeFontClass.isInstance(object)) {
            Object object3;
            Object object4;
            Method method2 = CompositeFont_getSlotFontMethod;
            if (method2 != null) {
                Object[] objectArray3 = object;
                Object[] objectArray4 = new Object[1];
                object = objectArray4;
                objectArray4[0] = 0;
                object4 = method2.invoke((Object)objectArray3, object);
            } else {
                object4 = null;
            }
            object2 = object4;
            Method method3 = Font2D_getFamilyNameMethod;
            if (method3 != null) {
                Object[] objectArray5 = new Object[1];
                object = objectArray5;
                objectArray5[0] = Locale.getDefault();
                object3 = method3.invoke(object2, object);
            } else {
                object3 = null;
            }
            return (String)object3;
        }
        Class<?> clazz = CFontClass;
        boolean bl = clazz != null ? clazz.isInstance(object) : false;
        if (bl) {
            object2 = ReflectionUtil.INSTANCE.getFieldValueOrNull(CFontClass, object, String.class, "nativeFontName");
            return this.getFontFamilyName(new Font((String)object2, 0, 10));
        }
        throw new IllegalStateException(("Unsupported Font2D subclass: " + object.getClass().getName()).toString());
    }

    public static /* synthetic */ String resolvePhysicalFontNameOrNull$skiko$default(AwtFontUtils awtFontUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return awtFontUtils.resolvePhysicalFontNameOrNull$skiko(string, n);
    }

    public final SortedSet<String> fontFamilyNamesOrNull(GraphicsEnvironment object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        Font[] fontArray = ((GraphicsEnvironment)object).getAllFonts();
        Intrinsics.checkNotNullExpressionValue((Object)fontArray, (String)"");
        object = fontArray;
        Object[] objectArray = object;
        object = new ArrayList(((Object[])object).length);
        for (Object object2 : objectArray) {
            object2 = (Font)object2;
            Object object3 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"");
            String string = INSTANCE.getFontFamilyName((Font)object2);
            Intrinsics.checkNotNull((Object)string);
            object3.add(string);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)object));
    }

    public static /* synthetic */ SortedSet fontFamilyNamesOrNull$default(AwtFontUtils awtFontUtils, GraphicsEnvironment graphicsEnvironment, int n, Object object) {
        if ((n & 1) != 0) {
            GraphicsEnvironment graphicsEnvironment2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsEnvironment2, (String)"");
            graphicsEnvironment = graphicsEnvironment2;
        }
        return awtFontUtils.fontFamilyNamesOrNull(graphicsEnvironment);
    }

    public final String getFontFamilyName(Font object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        object = this.obtainFont2D((Font)object);
        Method method = Font2D_getTypographicFamilyNameMethod;
        if (method == null) {
            object = "Font2D#getTypographicFamilyName() is not available";
            throw new IllegalStateException(object.toString());
        }
        object = method.invoke(object, new Object[0]);
        Intrinsics.checkNotNull((Object)object);
        return (String)object;
    }

    public final String getFontFileName(Font object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        if (!FileFontClass.isInstance(object = this.obtainFont2D((Font)object))) {
            return null;
        }
        Method method = FileFont_getPublicFileNameMethod;
        if (method == null) {
            object = "FileFont#getPublicFileName() is not available";
            throw new IllegalStateException(object.toString());
        }
        object = method.invoke(object, new Object[0]);
        Intrinsics.checkNotNull((Object)object);
        return (String)object;
    }

    private final Object obtainFont2D(Font object) {
        ConcurrentMap concurrentMap = font2DHandlesCache;
        Object object2 = concurrentMap.get(object);
        if (object2 == null) {
            Object object3 = INSTANCE.awtFontManager();
            Method method = FontManager_findFont2DMethod;
            if (method == null) {
                object = "FontManager#findFont2DMethod() is not available";
                throw new IllegalStateException(object.toString());
            }
            Object[] objectArray = object3;
            Object[] objectArray2 = new Object[3];
            object3 = objectArray2;
            objectArray2[0] = ((Font)object).getName();
            object3[1] = ((Font)object).getStyle();
            object3[2] = 2;
            object3 = method.invoke((Object)objectArray, object3);
            Field field = Font2D_handleField;
            if (field == null) {
                object = "Font2D#handle is not available";
                throw new IllegalStateException(object.toString());
            }
            object2 = concurrentMap.putIfAbsent(object, object3 = field.get(object3));
            if (object2 == null) {
                object2 = object3;
            }
        }
        object = object2;
        Field field = Font2DHandle_font2DField;
        if (field == null) {
            object = "Font2DHandle#font2D is not available";
            throw new IllegalStateException(object.toString());
        }
        Object object4 = field.get(object);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"");
        return object4;
    }

    private final Object awtFontManager() {
        Method method = FontManagerFactory_getInstanceMethod;
        if (method == null) {
            String string = "FontManagerFactory#getInstanceMethod() not available";
            throw new IllegalStateException(string.toString());
        }
        return method.invoke(null, new Object[0]);
    }

    private final Method getFont2DMethodOrNull(String string, Class<?> ... classArray) {
        Class<?> clazz = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, string, Arrays.copyOf(classArray, classArray.length));
    }

    private static final boolean Font2D_handleField$lambda$0(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        return (Boolean)function1.invoke(object);
    }

    private static final boolean Font2DHandle_font2DField$lambda$1(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        return (Boolean)function1.invoke(object);
    }

    static {
        InternalSunApiChecker.INSTANCE.isSunFontApiAccessible();
        FontManagerFactoryClass = Class.forName("sun.font.FontManagerFactory");
        FontManagerClass = Class.forName("sun.font.FontManager");
        Font2DClass = Class.forName("sun.font.Font2D");
        FileFontClass = Class.forName("sun.font.FileFont");
        CompositeFontClass = Class.forName("sun.font.CompositeFont");
        CFontClass = OsArch_jvmKt.getHostOs().isMacOS() ? Class.forName("sun.font.CFont") : null;
        Class<?> clazz = FontManagerFactoryClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        FontManagerFactory_getInstanceMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, "getInstance", new Class[0]);
        Class<?> clazz2 = FontManagerClass;
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
        Class[] classArray = new Class[3];
        Class[] classArray2 = classArray;
        classArray[0] = String.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        Intrinsics.checkNotNull(Integer.TYPE);
        FontManager_findFont2DMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz2, "findFont2D", classArray2);
        Font2D_getTypographicFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getTypographicFamilyName", new Class[0]);
        Class[] classArray3 = new Class[1];
        classArray2 = classArray3;
        classArray3[0] = Locale.class;
        Font2D_getFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getFamilyName", classArray2);
        Class<?> clazz3 = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"");
        Font2D_handleField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz3, arg_0 -> AwtFontUtils.Font2D_handleField$lambda$0(AwtFontUtils$Font2D_handleField$1.INSTANCE, arg_0));
        Class<?> clazz4 = Class.forName("sun.font.Font2DHandle");
        Intrinsics.checkNotNullExpressionValue(clazz4, (String)"");
        Font2DHandle_font2DField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz4, arg_0 -> AwtFontUtils.Font2DHandle_font2DField$lambda$1(AwtFontUtils$Font2DHandle_font2DField$1.INSTANCE, arg_0));
        Class<?> clazz5 = FileFontClass;
        Intrinsics.checkNotNullExpressionValue(clazz5, (String)"");
        FileFont_getPublicFileNameMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz5, "getPublicFileNameMethod", new Class[0]);
        Class<?> clazz6 = CompositeFontClass;
        Intrinsics.checkNotNullExpressionValue(clazz6, (String)"");
        Class[] classArray4 = new Class[1];
        classArray2 = classArray4;
        Class<Integer> clazz7 = Integer.TYPE;
        Intrinsics.checkNotNull(clazz7);
        classArray4[0] = clazz7;
        CompositeFont_getSlotFontMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz6, "getSlotFont", classArray2);
        font2DHandlesCache = new ConcurrentHashMap();
    }
}

