/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.awt.font;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skiko.awt.font.FontFamily$Companion;
import org.jetbrains.skiko.awt.font.FontFamily$FontFamilySource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 52\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u000256B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u0011\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0003H\u0096\u0001J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0013\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020\u0002H\u0096\u0003J\t\u0010-\u001a\u00020'H\u0096\u0001J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0002H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u0011\u00100\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0002H\u0086\u0002J\u0011\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u0011\u00101\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u0011\u00102\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u000e\u00103\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u000e\u00104\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0002R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR$\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00130\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00067"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamily;", "", "Lorg/jetbrains/skia/FontStyle;", "Lorg/jetbrains/skia/Typeface;", "familyName", "", "source", "Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;", "typefacesByStyle", "", "(Ljava/lang/String;Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;Ljava/util/Map;)V", "availableStyles", "", "getAvailableStyles", "()Ljava/util/Set;", "availableTypefaces", "", "getAvailableTypefaces", "entries", "", "getEntries", "getFamilyName", "()Ljava/lang/String;", "keys", "getKeys", "size", "", "getSize", "()I", "getSource", "()Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;", "values", "", "getValues", "()Ljava/util/Collection;", "addTypeface", "", "typeface", "containsKey", "", "key", "containsValue", "value", "ensureTypefaceIsCompatible", "get", "isEmpty", "minus", "style", "minusAssign", "plus", "plusAssign", "removeTypeface", "removeTypefaceByStyle", "Companion", "FontFamilySource", "skiko"})
public final class FontFamily
implements Map<FontStyle, Typeface>,
KMappedMarker {
    public static final FontFamily$Companion Companion = new FontFamily$Companion(null);
    private final String familyName;
    private final FontFamily$FontFamilySource source;
    private final Map<FontStyle, Typeface> typefacesByStyle;

    public FontFamily(String string, FontFamily$FontFamilySource fontFamily$FontFamilySource, Map<FontStyle, Typeface> map) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)fontFamily$FontFamilySource), (String)"");
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.familyName = string;
        this.source = fontFamily$FontFamilySource;
        this.typefacesByStyle = map;
        if (!(!StringsKt.isBlank((CharSequence)this.familyName))) {
            string = "The font family name must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ FontFamily(String string, FontFamily$FontFamilySource fontFamily$FontFamilySource, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        this(string, fontFamily$FontFamilySource, map);
    }

    public final String getFamilyName() {
        return this.familyName;
    }

    public final FontFamily$FontFamilySource getSource() {
        return this.source;
    }

    public final Set<Map.Entry<FontStyle, Typeface>> getEntries() {
        return this.typefacesByStyle.entrySet();
    }

    public final Set<FontStyle> getKeys() {
        return this.typefacesByStyle.keySet();
    }

    public final int getSize() {
        return this.typefacesByStyle.size();
    }

    public final Collection<Typeface> getValues() {
        return this.typefacesByStyle.values();
    }

    public final boolean containsKey(FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"");
        return this.typefacesByStyle.containsKey(fontStyle);
    }

    public final boolean containsValue(Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        return this.typefacesByStyle.containsValue(typeface);
    }

    public final Typeface get(FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"");
        return this.typefacesByStyle.get(fontStyle);
    }

    @Override
    public final boolean isEmpty() {
        return this.typefacesByStyle.isEmpty();
    }

    public final Set<FontStyle> getAvailableStyles() {
        return this.typefacesByStyle.keySet();
    }

    public final Set<Typeface> getAvailableTypefaces() {
        return CollectionsKt.toSet((Iterable)this.typefacesByStyle.values());
    }

    public final FontFamily plus(Typeface typeface) {
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        FontFamily fontFamily2 = fontFamily = new FontFamily(this.familyName, this.source, MapsKt.toMutableMap(this.typefacesByStyle));
        fontFamily.addTypeface(typeface);
        return fontFamily;
    }

    public final void plusAssign(Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        this.addTypeface(typeface);
    }

    public final void addTypeface(Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        this.ensureTypefaceIsCompatible(typeface);
        Map<FontStyle, Typeface> map = this.typefacesByStyle;
        typeface = TuplesKt.to((Object)typeface.getFontStyle(), (Object)typeface);
        map.put((FontStyle)typeface.getFirst(), (Typeface)typeface.getSecond());
    }

    public final void minusAssign(Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        this.removeTypeface(typeface);
    }

    public final FontFamily minus(Typeface typeface) {
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        FontFamily fontFamily2 = fontFamily = new FontFamily(this.familyName, this.source, MapsKt.toMutableMap(this.typefacesByStyle));
        fontFamily.removeTypeface(typeface);
        return fontFamily;
    }

    public final void minusAssign(FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"");
        this.removeTypefaceByStyle(fontStyle);
    }

    public final FontFamily minus(FontStyle fontStyle) {
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"");
        FontFamily fontFamily2 = fontFamily = new FontFamily(this.familyName, this.source, MapsKt.toMutableMap(this.typefacesByStyle));
        fontFamily.removeTypefaceByStyle(fontStyle);
        return fontFamily;
    }

    public final void removeTypeface(Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"");
        if (this.typefacesByStyle.isEmpty()) {
            return;
        }
        FontStyle fontStyle = typeface.getFontStyle();
        this.ensureTypefaceIsCompatible(typeface);
        this.typefacesByStyle.remove(fontStyle);
    }

    private final void ensureTypefaceIsCompatible(Typeface object) {
        String string = ((Typeface)object).getFamilyName();
        if (!StringsKt.equals((String)this.familyName, (String)string, (boolean)true)) {
            object = "The provided typeface " + object + " is not compatible with this font family, '" + this.familyName + '\'';
            throw new IllegalArgumentException(object.toString());
        }
    }

    public final void removeTypefaceByStyle(FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"");
        this.typefacesByStyle.remove(fontStyle);
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface compute(FontStyle fontStyle, BiFunction<? super FontStyle, ? super Typeface, ? extends Typeface> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface computeIfAbsent(FontStyle fontStyle, Function<? super FontStyle, ? extends Typeface> function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface computeIfPresent(FontStyle fontStyle, BiFunction<? super FontStyle, ? super Typeface, ? extends Typeface> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface merge(FontStyle fontStyle, Typeface typeface, BiFunction<? super Typeface, ? super Typeface, ? extends Typeface> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface put(FontStyle fontStyle, Typeface typeface) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final void putAll(Map<? extends FontStyle, ? extends Typeface> map) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface putIfAbsent(FontStyle fontStyle, Typeface typeface) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final boolean replace(FontStyle fontStyle, Typeface typeface, Typeface typeface2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Typeface replace(FontStyle fontStyle, Typeface typeface) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final void replaceAll(BiFunction<? super FontStyle, ? super Typeface, ? extends Typeface> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final Set<Map.Entry<FontStyle, Typeface>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<FontStyle> keySet() {
        return this.getKeys();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Collection<Typeface> values() {
        return this.getValues();
    }

    @Override
    public final /* synthetic */ Object compute(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ Object computeIfAbsent(Object object, Function function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ Object computeIfPresent(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ Object merge(Object object, Object object2, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ Object put(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ Object putIfAbsent(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ boolean replace(Object object, Object object2, Object object3) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final /* synthetic */ Object replace(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

