/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphSubstitutionTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.SubstitutingCmapLookup;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.util.BoundingBox;

public class TrueTypeFont
implements Closeable,
FontBoxFont {
    private static final Log LOG = LogFactory.getLog(TrueTypeFont.class);
    private float version;
    private int numberOfGlyphs = -1;
    private int unitsPerEm = -1;
    protected final Map<String, TTFTable> tables = new HashMap<String, TTFTable>();
    private final TTFDataStream data;
    private volatile Map<String, Integer> postScriptNames;
    private final Object lockReadtable = new Object();
    private final Object lockPSNames = new Object();
    private final List<String> enabledGsubFeatures = new ArrayList<String>();

    TrueTypeFont(TTFDataStream tTFDataStream) {
        this.data = tTFDataStream;
    }

    @Override
    public void close() {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    void setVersion(float f2) {
        this.version = f2;
    }

    void addTable(TTFTable tTFTable) {
        this.tables.put(tTFTable.getTag(), tTFTable);
    }

    public Collection<TTFTable> getTables() {
        return this.tables.values();
    }

    public Map<String, TTFTable> getTableMap() {
        return this.tables;
    }

    public byte[] getTableBytes(TTFTable object) {
        Object object2 = this.lockReadtable;
        synchronized (object2) {
            long l = this.data.getCurrentPosition();
            this.data.seek(((TTFTable)object).getOffset());
            object = this.data.read((int)((TTFTable)object).getLength());
            this.data.seek(l);
            return object;
        }
    }

    protected TTFTable getTable(String object) {
        if ((object = this.tables.get(object)) != null && !((TTFTable)object).getInitialized()) {
            this.readTable((TTFTable)object);
        }
        return object;
    }

    public NamingTable getNaming() {
        return (NamingTable)this.getTable("name");
    }

    public PostScriptTable getPostScript() {
        return (PostScriptTable)this.getTable("post");
    }

    public OS2WindowsMetricsTable getOS2Windows() {
        return (OS2WindowsMetricsTable)this.getTable("OS/2");
    }

    public MaximumProfileTable getMaximumProfile() {
        return (MaximumProfileTable)this.getTable("maxp");
    }

    public HeaderTable getHeader() {
        return (HeaderTable)this.getTable("head");
    }

    public HorizontalHeaderTable getHorizontalHeader() {
        return (HorizontalHeaderTable)this.getTable("hhea");
    }

    public HorizontalMetricsTable getHorizontalMetrics() {
        return (HorizontalMetricsTable)this.getTable("hmtx");
    }

    public IndexToLocationTable getIndexToLocation() {
        return (IndexToLocationTable)this.getTable("loca");
    }

    public GlyphTable getGlyph() {
        return (GlyphTable)this.getTable("glyf");
    }

    public CmapTable getCmap() {
        return (CmapTable)this.getTable("cmap");
    }

    public VerticalHeaderTable getVerticalHeader() {
        return (VerticalHeaderTable)this.getTable("vhea");
    }

    public VerticalMetricsTable getVerticalMetrics() {
        return (VerticalMetricsTable)this.getTable("vmtx");
    }

    public VerticalOriginTable getVerticalOrigin() {
        return (VerticalOriginTable)this.getTable("VORG");
    }

    public KerningTable getKerning() {
        return (KerningTable)this.getTable("kern");
    }

    public GlyphSubstitutionTable getGsub() {
        return (GlyphSubstitutionTable)this.getTable("GSUB");
    }

    public InputStream getOriginalData() {
        return this.data.getOriginalData();
    }

    public long getOriginalDataSize() {
        return this.data.getOriginalDataSize();
    }

    void readTable(TTFTable tTFTable) {
        long l = this.data.getCurrentPosition();
        this.data.seek(tTFTable.getOffset());
        TrueTypeFont trueTypeFont = this;
        tTFTable.read(trueTypeFont, trueTypeFont.data);
        this.data.seek(l);
    }

    public int getNumberOfGlyphs() {
        if (this.numberOfGlyphs == -1) {
            MaximumProfileTable maximumProfileTable = this.getMaximumProfile();
            this.numberOfGlyphs = maximumProfileTable != null ? maximumProfileTable.getNumGlyphs() : 0;
        }
        return this.numberOfGlyphs;
    }

    public int getUnitsPerEm() {
        if (this.unitsPerEm == -1) {
            HeaderTable headerTable = this.getHeader();
            this.unitsPerEm = headerTable != null ? headerTable.getUnitsPerEm() : 0;
        }
        return this.unitsPerEm;
    }

    public int getAdvanceWidth(int n) {
        HorizontalMetricsTable horizontalMetricsTable = this.getHorizontalMetrics();
        if (horizontalMetricsTable != null) {
            return horizontalMetricsTable.getAdvanceWidth(n);
        }
        return 250;
    }

    public int getAdvanceHeight(int n) {
        VerticalMetricsTable verticalMetricsTable = this.getVerticalMetrics();
        if (verticalMetricsTable != null) {
            return verticalMetricsTable.getAdvanceHeight(n);
        }
        return 250;
    }

    @Override
    public String getName() {
        NamingTable namingTable = this.getNaming();
        if (namingTable != null) {
            return namingTable.getPostScriptName();
        }
        return null;
    }

    private void readPostScriptNames() {
        Map<String, Integer> map = this.postScriptNames;
        if (map == null) {
            String[] stringArray = this.getPostScript();
            Object object = this.lockPSNames;
            synchronized (object) {
                map = this.postScriptNames;
                if (map == null) {
                    if ((stringArray = stringArray != null ? stringArray.getGlyphNames() : null) != null) {
                        map = new HashMap<String, Integer>(stringArray.length);
                        for (int i = 0; i < stringArray.length; ++i) {
                            map.put(stringArray[i], i);
                        }
                    } else {
                        map = new HashMap<String, Integer>();
                    }
                    this.postScriptNames = map;
                }
                return;
            }
        }
    }

    public CmapLookup getUnicodeCmapLookup() {
        return this.getUnicodeCmapLookup(true);
    }

    public CmapLookup getUnicodeCmapLookup(boolean bl) {
        GlyphSubstitutionTable glyphSubstitutionTable;
        CmapSubtable cmapSubtable = this.getUnicodeCmapImpl(bl);
        if (!this.enabledGsubFeatures.isEmpty() && (glyphSubstitutionTable = this.getGsub()) != null) {
            return new SubstitutingCmapLookup(cmapSubtable, glyphSubstitutionTable, Collections.unmodifiableList(this.enabledGsubFeatures));
        }
        return cmapSubtable;
    }

    private CmapSubtable getUnicodeCmapImpl(boolean bl) {
        CmapTable cmapTable = this.getCmap();
        if (cmapTable == null) {
            if (bl) {
                throw new IOException("The TrueType font " + this.getName() + " does not contain a 'cmap' table");
            }
            return null;
        }
        CmapSubtable cmapSubtable = cmapTable.getSubtable(0, 4);
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(3, 10);
        }
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(0, 3);
        }
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(3, 1);
        }
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(3, 0);
        }
        if (cmapSubtable == null) {
            if (bl) {
                throw new IOException("The TrueType font does not contain a Unicode cmap");
            }
            if (cmapTable.getCmaps().length > 0) {
                cmapSubtable = cmapTable.getCmaps()[0];
            }
        }
        return cmapSubtable;
    }

    public int nameToGID(String object) {
        Integer n;
        this.readPostScriptNames();
        if (this.postScriptNames != null && (n = this.postScriptNames.get(object)) != null && n > 0 && n < this.getMaximumProfile().getNumGlyphs()) {
            return n;
        }
        int n2 = this.parseUniName((String)object);
        if (n2 >= 0) {
            object = this.getUnicodeCmapLookup(false);
            return object.getGlyphId(n2);
        }
        if (((String)object).matches("g\\d+")) {
            return Integer.parseInt(((String)object).substring(1));
        }
        return 0;
    }

    public GsubData getGsubData() {
        GlyphSubstitutionTable glyphSubstitutionTable = this.getGsub();
        if (glyphSubstitutionTable == null) {
            return GsubData.NO_DATA_FOUND;
        }
        return glyphSubstitutionTable.getGsubData();
    }

    private int parseUniName(String string) {
        if (string.startsWith("uni") && string.length() == 7) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n2 = 3;
                while (n2 + 4 <= n) {
                    int n3 = n2;
                    int n4 = Integer.parseInt(string.substring(n3, n3 + 4), 16);
                    if (n4 <= 55295 || n4 >= 57344) {
                        stringBuilder.append((char)n4);
                    }
                    n2 += 4;
                }
                String string2 = stringBuilder.toString();
                if (string2.length() == 0) {
                    return -1;
                }
                return string2.codePointAt(0);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public GeneralPath getPath(String string) {
        int n = this.nameToGID(string);
        GlyphData glyphData = this.getGlyph().getGlyph(n);
        if (glyphData == null) {
            return new GeneralPath();
        }
        return glyphData.getPath();
    }

    @Override
    public float getWidth(String string) {
        int n = this.nameToGID(string);
        return this.getAdvanceWidth(n);
    }

    @Override
    public boolean hasGlyph(String string) {
        return this.nameToGID(string) != 0;
    }

    @Override
    public BoundingBox getFontBBox() {
        HeaderTable headerTable = this.getHeader();
        short s = headerTable.getXMin();
        short s2 = headerTable.getXMax();
        short s3 = headerTable.getYMin();
        short s4 = headerTable.getYMax();
        float f2 = 1000.0f / (float)this.getUnitsPerEm();
        return new BoundingBox((float)s * f2, (float)s3 * f2, (float)s2 * f2, (float)s4 * f2);
    }

    @Override
    public List<Number> getFontMatrix() {
        float f2 = 1000.0f / (float)this.getUnitsPerEm();
        return Arrays.asList(Float.valueOf(0.001f * f2), 0, 0, Float.valueOf(0.001f * f2), 0, 0);
    }

    public void enableGsubFeature(String string) {
        this.enabledGsubFeatures.add(string);
    }

    public void disableGsubFeature(String string) {
        this.enabledGsubFeatures.remove(string);
    }

    public void enableVerticalSubstitutions() {
        this.enableGsubFeature("vrt2");
        this.enableGsubFeature("vert");
    }

    public String toString() {
        try {
            NamingTable namingTable = this.getNaming();
            if (namingTable != null) {
                return namingTable.getPostScriptName();
            }
            return "(null)";
        }
        catch (IOException iOException) {
            LOG.debug((Object)"Error getting the NamingTable for the font", (Throwable)iOException);
            return "(null - " + iOException.getMessage() + ")";
        }
    }
}

