/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.impl.WeakHashtable$1;
import org.apache.commons.logging.impl.WeakHashtable$Entry;
import org.apache.commons.logging.impl.WeakHashtable$Referenced;
import org.apache.commons.logging.impl.WeakHashtable$WeakKey;

public final class WeakHashtable
extends Hashtable {
    private static final long serialVersionUID = -1546036869799732453L;
    private static final int MAX_CHANGES_BEFORE_PURGE = 100;
    private static final int PARTIAL_PURGE_COUNT = 10;
    private final ReferenceQueue queue = new ReferenceQueue();
    private int changeCount = 0;

    public final boolean containsKey(Object object) {
        object = new WeakHashtable$Referenced(object, null);
        return super.containsKey(object);
    }

    public final Enumeration elements() {
        this.purge();
        return super.elements();
    }

    public final Set entrySet() {
        this.purge();
        Object object = super.entrySet();
        HashSet<Map.Entry> hashSet = new HashSet<Map.Entry>();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Object object2 = (WeakHashtable$Referenced)entry.getKey();
            object2 = WeakHashtable$Referenced.access$100((WeakHashtable$Referenced)object2);
            entry = entry.getValue();
            if (object2 == null) continue;
            entry = new WeakHashtable$Entry(object2, entry, null);
            hashSet.add(entry);
        }
        return hashSet;
    }

    public final Object get(Object object) {
        object = new WeakHashtable$Referenced(object, null);
        return super.get(object);
    }

    public final Enumeration keys() {
        this.purge();
        Enumeration enumeration = super.keys();
        return new WeakHashtable$1(this, enumeration);
    }

    public final Set keySet() {
        this.purge();
        Object object = super.keySet();
        HashSet<Object> hashSet = new HashSet<Object>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (WeakHashtable$Referenced)object.next();
            if ((object2 = WeakHashtable$Referenced.access$100((WeakHashtable$Referenced)object2)) == null) continue;
            hashSet.add(object2);
        }
        return hashSet;
    }

    public final synchronized Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (object2 == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        object = new WeakHashtable$Referenced(object, this.queue, null);
        return super.put(object, object2);
    }

    public final void putAll(Map iterator) {
        if (iterator != null) {
            iterator = iterator.entrySet();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public final Collection values() {
        this.purge();
        return super.values();
    }

    public final synchronized Object remove(Object object) {
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        return super.remove(new WeakHashtable$Referenced(object, null));
    }

    public final boolean isEmpty() {
        this.purge();
        return super.isEmpty();
    }

    public final int size() {
        this.purge();
        return super.size();
    }

    public final String toString() {
        this.purge();
        return super.toString();
    }

    protected final void rehash() {
        this.purge();
        super.rehash();
    }

    private void purge() {
        ArrayList<WeakHashtable$Referenced> arrayList = new ArrayList<WeakHashtable$Referenced>();
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakHashtable$WeakKey weakHashtable$WeakKey;
            while ((weakHashtable$WeakKey = (WeakHashtable$WeakKey)this.queue.poll()) != null) {
                arrayList.add(WeakHashtable$WeakKey.access$400(weakHashtable$WeakKey));
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            super.remove(arrayList.get(i));
        }
    }

    private void purgeOne() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakHashtable$WeakKey weakHashtable$WeakKey = (WeakHashtable$WeakKey)this.queue.poll();
            if (weakHashtable$WeakKey != null) {
                super.remove(WeakHashtable$WeakKey.access$400(weakHashtable$WeakKey));
            }
            return;
        }
    }
}

