/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Loader;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;

public class EnvUtil {
    private EnvUtil() {
    }

    public static String logbackVersion() {
        Object object = EnvUtil.logbackVersionByModule();
        if (object != null) {
            return object;
        }
        object = EnvUtil.class.getPackage();
        if (object == null) {
            return null;
        }
        return ((Package)object).getImplementationVersion();
    }

    private static String logbackVersionByModule() {
        Object object = EnvUtil.class.getModule();
        if (object == null) {
            return null;
        }
        if ((object = ((Module)object).getDescriptor()) == null) {
            return null;
        }
        object = ((ModuleDescriptor)object).rawVersion();
        return ((Optional)object).orElse(null);
    }

    public static int getJDKVersion(String object) {
        int n = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object2 = object[i];
            if (Character.isDigit((char)object2)) {
                n = n * 10 + (object2 - 48);
                continue;
            }
            if (n != 1) break;
            n = 0;
        }
        return n;
    }

    private static boolean isJDK_N_OrHigher(int n) {
        String string = System.getProperty("java.version", "");
        if (string.isEmpty()) {
            return false;
        }
        int n2 = EnvUtil.getJDKVersion(string);
        return n2 > 0 && n <= n2;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK16OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(16);
    }

    public static boolean isJDK18OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(18);
    }

    public static boolean isJDK21OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(21);
    }

    public static boolean isJaninoAvailable() {
        Object object = EnvUtil.class.getClassLoader();
        try {
            object = ((ClassLoader)object).loadClass("org.codehaus.janino.ScriptEvaluator");
            return object != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    public static boolean isClassAvailable(Class clazz, String string) {
        clazz = Loader.getClassLoaderOfClass(clazz);
        try {
            clazz = ((ClassLoader)((Object)clazz)).loadClass(string);
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

