/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractTypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$TypeAlias;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;

public final class DeserializedTypeAliasDescriptor
extends AbstractTypeAliasDescriptor
implements DeserializedMemberDescriptor {
    private final ProtoBuf$TypeAlias proto;
    private final NameResolver nameResolver;
    private final TypeTable typeTable;
    private final VersionRequirementTable versionRequirementTable;
    private final DeserializedContainerSource containerSource;
    private SimpleType underlyingType;
    private SimpleType expandedType;
    private List<? extends TypeParameterDescriptor> typeConstructorParameters;
    private SimpleType defaultTypeImpl;

    public DeserializedTypeAliasDescriptor(StorageManager storageManager, DeclarationDescriptor declarationDescriptor, Annotations annotations2, Name name, DescriptorVisibility descriptorVisibility, ProtoBuf$TypeAlias protoBuf$TypeAlias, NameResolver nameResolver, TypeTable typeTable, VersionRequirementTable versionRequirementTable, DeserializedContainerSource deserializedContainerSource) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)descriptorVisibility, (String)"");
        Intrinsics.checkNotNullParameter((Object)protoBuf$TypeAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
        super(storageManager, declarationDescriptor, annotations2, name, sourceElement, descriptorVisibility);
        this.proto = protoBuf$TypeAlias;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        this.versionRequirementTable = versionRequirementTable;
        this.containerSource = deserializedContainerSource;
    }

    @Override
    public final ProtoBuf$TypeAlias getProto() {
        return this.proto;
    }

    @Override
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @Override
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final VersionRequirementTable getVersionRequirementTable() {
        return this.versionRequirementTable;
    }

    @Override
    public final DeserializedContainerSource getContainerSource() {
        return this.containerSource;
    }

    @Override
    public final SimpleType getUnderlyingType() {
        SimpleType simpleType2 = this.underlyingType;
        if (simpleType2 != null) {
            return simpleType2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    @Override
    public final SimpleType getExpandedType() {
        SimpleType simpleType2 = this.expandedType;
        if (simpleType2 != null) {
            return simpleType2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    public final void initialize(List<? extends TypeParameterDescriptor> list, SimpleType simpleType2, SimpleType simpleType3) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        Intrinsics.checkNotNullParameter((Object)simpleType3, (String)"");
        this.initialize(list);
        this.underlyingType = simpleType2;
        this.expandedType = simpleType3;
        this.typeConstructorParameters = TypeParameterUtilsKt.computeConstructorTypeParameters(this);
        this.defaultTypeImpl = this.computeDefaultType();
    }

    @Override
    public final ClassDescriptor getClassDescriptor() {
        ClassifierDescriptor classifierDescriptor;
        if (!KotlinTypeKt.isError(this.getExpandedType()) && (classifierDescriptor = this.getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @Override
    public final SimpleType getDefaultType() {
        SimpleType simpleType2 = this.defaultTypeImpl;
        if (simpleType2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            simpleType2 = null;
        }
        return simpleType2;
    }

    @Override
    public final TypeAliasDescriptor substitute(TypeSubstitutor typeSubstitutor2) {
        Intrinsics.checkNotNullParameter((Object)typeSubstitutor2, (String)"");
        if (typeSubstitutor2.isEmpty()) {
            return this;
        }
        StorageManager storageManager = this.getStorageManager();
        DeclarationDescriptor declarationDescriptor = this.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        Annotations annotations2 = this.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"");
        Name name = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        DeserializedTypeAliasDescriptor deserializedTypeAliasDescriptor = new DeserializedTypeAliasDescriptor(storageManager, declarationDescriptor, annotations2, name, this.getVisibility(), this.getProto(), this.getNameResolver(), this.getTypeTable(), this.getVersionRequirementTable(), this.getContainerSource());
        List<TypeParameterDescriptor> list = this.getDeclaredTypeParameters();
        KotlinType kotlinType = typeSubstitutor2.safeSubstitute(this.getUnderlyingType(), Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        SimpleType simpleType2 = TypeSubstitutionKt.asSimpleType(kotlinType);
        KotlinType kotlinType2 = typeSubstitutor2.safeSubstitute(this.getExpandedType(), Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        deserializedTypeAliasDescriptor.initialize(list, simpleType2, TypeSubstitutionKt.asSimpleType(kotlinType2));
        return deserializedTypeAliasDescriptor;
    }

    @Override
    protected final List<TypeParameterDescriptor> getTypeConstructorTypeParameters() {
        List<TypeParameterDescriptor> list = this.typeConstructorParameters;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            list = null;
        }
        return list;
    }
}

