/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;

public final class AbstractStrictEqualityTypeChecker {
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker2, (String)"");
        return this.strictEqualTypesInternal(typeSystemContext, kotlinTypeMarker, kotlinTypeMarker2);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        if (kotlinTypeMarker == kotlinTypeMarker2) {
            return true;
        }
        SimpleTypeMarker simpleTypeMarker = typeSystemContext.asSimpleType(kotlinTypeMarker);
        SimpleTypeMarker simpleTypeMarker2 = typeSystemContext.asSimpleType(kotlinTypeMarker2);
        if (simpleTypeMarker != null && simpleTypeMarker2 != null) {
            return this.strictEqualSimpleTypes(typeSystemContext, simpleTypeMarker, simpleTypeMarker2);
        }
        kotlinTypeMarker = typeSystemContext.asFlexibleType(kotlinTypeMarker);
        kotlinTypeMarker2 = typeSystemContext.asFlexibleType(kotlinTypeMarker2);
        if (kotlinTypeMarker != null && kotlinTypeMarker2 != null) {
            TypeSystemContext typeSystemContext2 = typeSystemContext;
            if (this.strictEqualSimpleTypes(typeSystemContext2, typeSystemContext2.lowerBound((FlexibleTypeMarker)kotlinTypeMarker), typeSystemContext.lowerBound((FlexibleTypeMarker)kotlinTypeMarker2))) {
                TypeSystemContext typeSystemContext3 = typeSystemContext;
                if (this.strictEqualSimpleTypes(typeSystemContext3, typeSystemContext3.upperBound((FlexibleTypeMarker)kotlinTypeMarker), typeSystemContext.upperBound((FlexibleTypeMarker)kotlinTypeMarker2))) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private final boolean strictEqualSimpleTypes(TypeSystemContext typeSystemContext, SimpleTypeMarker simpleTypeMarker, SimpleTypeMarker simpleTypeMarker2) {
        block8: {
            block7: {
                if (typeSystemContext.argumentsCount(simpleTypeMarker) != typeSystemContext.argumentsCount(simpleTypeMarker2) || typeSystemContext.isMarkedNullable(simpleTypeMarker) != typeSystemContext.isMarkedNullable(simpleTypeMarker2) || typeSystemContext.asDefinitelyNotNullType(simpleTypeMarker) == null != (typeSystemContext.asDefinitelyNotNullType(simpleTypeMarker2) == null)) break block7;
                TypeSystemContext typeSystemContext2 = typeSystemContext;
                if (typeSystemContext2.areEqualTypeConstructors(typeSystemContext2.typeConstructor(simpleTypeMarker), typeSystemContext.typeConstructor(simpleTypeMarker2))) break block8;
            }
            return false;
        }
        if (typeSystemContext.identicalArguments(simpleTypeMarker, simpleTypeMarker2)) {
            return true;
        }
        int n = typeSystemContext.argumentsCount(simpleTypeMarker);
        for (int i = 0; i < n; ++i) {
            TypeArgumentMarker typeArgumentMarker = typeSystemContext.getArgument(simpleTypeMarker, i);
            TypeArgumentMarker typeArgumentMarker2 = typeSystemContext.getArgument(simpleTypeMarker2, i);
            if (typeSystemContext.isStarProjection(typeArgumentMarker) != typeSystemContext.isStarProjection(typeArgumentMarker2)) {
                return false;
            }
            if (typeSystemContext.isStarProjection(typeArgumentMarker)) continue;
            if (typeSystemContext.getVariance(typeArgumentMarker) != typeSystemContext.getVariance(typeArgumentMarker2)) {
                return false;
            }
            TypeSystemContext typeSystemContext3 = typeSystemContext;
            if (this.strictEqualTypesInternal(typeSystemContext3, typeSystemContext3.getType(typeArgumentMarker), typeSystemContext.getType(typeArgumentMarker2))) continue;
            return false;
        }
        return true;
    }
}

