/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;

public final class FlexibleTypesKt {
    public static final boolean isFlexible(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType.unwrap() instanceof FlexibleType;
    }

    public static final FlexibleType asFlexibleType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        Intrinsics.checkNotNull((Object)unwrappedType);
        return (FlexibleType)unwrappedType;
    }

    public static final SimpleType lowerIfFlexible(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        kotlinType = kotlinType.unwrap();
        UnwrappedType unwrappedType = kotlinType;
        if (kotlinType instanceof FlexibleType) {
            return ((FlexibleType)kotlinType).getLowerBound();
        }
        if (unwrappedType instanceof SimpleType) {
            return (SimpleType)kotlinType;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final SimpleType upperIfFlexible(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        kotlinType = kotlinType.unwrap();
        UnwrappedType unwrappedType = kotlinType;
        if (kotlinType instanceof FlexibleType) {
            return ((FlexibleType)kotlinType).getUpperBound();
        }
        if (unwrappedType instanceof SimpleType) {
            return (SimpleType)kotlinType;
        }
        throw new NoWhenBranchMatchedException();
    }
}

