/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.processor.ConfigurationModelHandler;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import java.net.URL;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ConfigurationModelHandlerFull
extends ConfigurationModelHandler {
    public ConfigurationModelHandlerFull(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance2(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ConfigurationModelHandlerFull(context);
    }

    @Override
    protected void processScanAttrib(ModelInterpretationContext object, ConfigurationModel configurationModel) {
        Object object2 = object.subst(configurationModel.getScanStr());
        if (!OptionHelper.isNullOrEmpty((String)object2) && !"false".equalsIgnoreCase((String)object2)) {
            object2 = this.context.getScheduledExecutorService();
            URL uRL = ConfigurationWatchListUtil.getMainWatchURL((Context)this.context);
            if (uRL == null) {
                this.addWarn("Due to missing top level configuration file, reconfiguration on change (configuration file scanning) cannot be done.");
                return;
            }
            ReconfigureOnChangeTask reconfigureOnChangeTask = new ReconfigureOnChangeTask();
            reconfigureOnChangeTask.setContext(this.context);
            this.addInfo("Registering a new ReconfigureOnChangeTask " + String.valueOf(reconfigureOnChangeTask));
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRegisteredEvent((Object)reconfigureOnChangeTask));
            object = object.subst(configurationModel.getScanPeriodStr());
            object = this.getDurationOfScanPeriodAttribute((String)object, SCAN_PERIOD_DEFAULT);
            this.addInfo("Will scan for changes in [" + String.valueOf(uRL) + "] ");
            this.addInfo("Setting ReconfigureOnChangeTask scanning period to " + String.valueOf(object));
            object = object2.scheduleAtFixedRate(reconfigureOnChangeTask, object.getMilliseconds(), object.getMilliseconds(), TimeUnit.MILLISECONDS);
            reconfigureOnChangeTask.setScheduredFuture((ScheduledFuture<?>)object);
            this.context.addScheduledFuture((ScheduledFuture)object);
        }
    }

    private Duration getDurationOfScanPeriodAttribute(String string, Duration duration) {
        Duration duration2 = null;
        if (!OptionHelper.isNullOrEmpty((String)string)) {
            try {
                duration2 = Duration.valueOf((String)string);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                this.addWarn("Failed to parse 'scanPeriod' attribute [" + string + "]", runtimeException);
            }
        }
        if (duration2 == null) {
            this.addInfo("No 'scanPeriod' specified. Defaulting to " + duration.toString());
            duration2 = duration;
        }
        return duration2;
    }
}

