/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.DispatchListener;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.annotation.ComEventCallback;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.Guid$IID;
import com.sun.jna.platform.win32.Guid$REFIID;
import com.sun.jna.platform.win32.OaIdl$DISPID;
import com.sun.jna.platform.win32.OaIdl$DISPIDByReference;
import com.sun.jna.platform.win32.OaIdl$EXCEPINFO$ByReference;
import com.sun.jna.platform.win32.OleAuto$DISPPARAMS$ByReference;
import com.sun.jna.platform.win32.Variant$VARIANT;
import com.sun.jna.platform.win32.Variant$VARIANT$ByReference;
import com.sun.jna.platform.win32.WinDef$LCID;
import com.sun.jna.platform.win32.WinDef$UINT;
import com.sun.jna.platform.win32.WinDef$UINTByReference;
import com.sun.jna.platform.win32.WinDef$WORD;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CallbackProxy
implements IDispatchCallback {
    private static boolean DEFAULT_BOOLEAN;
    private static byte DEFAULT_BYTE;
    private static short DEFAULT_SHORT;
    private static int DEFAULT_INT;
    private static long DEFAULT_LONG;
    private static float DEFAULT_FLOAT;
    private static double DEFAULT_DOUBLE;
    ObjectFactory factory;
    Class<?> comEventCallbackInterface;
    IComEventCallbackListener comEventCallbackListener;
    Guid$REFIID listenedToRiid;
    public DispatchListener dispatchListener;
    Map<OaIdl$DISPID, Method> dsipIdMap;

    public CallbackProxy(ObjectFactory objectFactory, Class<?> clazz, IComEventCallbackListener iComEventCallbackListener) {
        this.factory = objectFactory;
        this.comEventCallbackInterface = clazz;
        this.comEventCallbackListener = iComEventCallbackListener;
        this.listenedToRiid = this.createRIID(clazz);
        this.dsipIdMap = this.createDispIdMap(clazz);
        this.dispatchListener = new DispatchListener(this);
    }

    Guid$REFIID createRIID(Class<?> object) {
        if ((object = ((Class)object).getAnnotation(ComInterface.class)) == null) {
            throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
        }
        if ((object = object.iid()) == null || ((String)object).isEmpty()) {
            throw new COMException("ComInterface must define a value for iid");
        }
        return new Guid$REFIID(new Guid$IID((String)object).getPointer());
    }

    Map<OaIdl$DISPID, Method> createDispIdMap(Class<?> methodArray) {
        HashMap<OaIdl$DISPID, Method> hashMap = new HashMap<OaIdl$DISPID, Method>();
        for (Method method : methodArray.getMethods()) {
            ComEventCallback comEventCallback = method.getAnnotation(ComEventCallback.class);
            ComMethod comMethod = method.getAnnotation(ComMethod.class);
            if (comMethod != null) {
                int n = comMethod.dispId();
                if (-1 == n) {
                    n = this.fetchDispIdFromName(comEventCallback);
                }
                if (n == -1) {
                    this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + method.getName() + " not found", null);
                }
                hashMap.put(new OaIdl$DISPID(n), method);
                continue;
            }
            if (comEventCallback == null) continue;
            int n = comEventCallback.dispid();
            if (-1 == n) {
                n = this.fetchDispIdFromName(comEventCallback);
            }
            if (n == -1) {
                this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + method.getName() + " not found", null);
            }
            hashMap.put(new OaIdl$DISPID(n), method);
        }
        return hashMap;
    }

    int fetchDispIdFromName(ComEventCallback comEventCallback) {
        return -1;
    }

    void invokeOnThread(OaIdl$DISPID oaIdl$DISPIDArray, Guid$REFIID object, WinDef$LCID object2, WinDef$WORD classArray, OleAuto$DISPPARAMS$ByReference objectArray) {
        Object[] objectArray2;
        int n;
        object = objectArray.getArgs();
        object2 = this.dsipIdMap.get(oaIdl$DISPIDArray);
        if (object2 == null) {
            this.comEventCallbackListener.errorReceivingCallbackEvent("No method found with dispId = " + oaIdl$DISPIDArray, null);
            return;
        }
        oaIdl$DISPIDArray = objectArray.getRgdispidNamedArgs();
        classArray = ((Method)object2).getParameterTypes();
        objectArray = new Object[classArray.length];
        for (n = 0; n < objectArray.length && ((Variant$VARIANT[])object).length - oaIdl$DISPIDArray.length - n > 0; ++n) {
            Class<?> clazz = classArray[n];
            objectArray2 = object[((Variant$VARIANT[])object).length - n - 1];
            objectArray[n] = Convert.toJavaObject(objectArray2, clazz, this.factory, true, false);
        }
        for (n = 0; n < oaIdl$DISPIDArray.length; ++n) {
            int n2 = oaIdl$DISPIDArray[n].intValue();
            if (n2 >= objectArray.length) continue;
            objectArray2 = classArray[n2];
            Variant$VARIANT variant$VARIANT = object[n];
            objectArray[n2] = Convert.toJavaObject(variant$VARIANT, objectArray2, this.factory, true, false);
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] != null || !classArray[n].isPrimitive()) continue;
            if (classArray[n].equals(Boolean.TYPE)) {
                objectArray[n] = DEFAULT_BOOLEAN;
                continue;
            }
            if (classArray[n].equals(Byte.TYPE)) {
                objectArray[n] = DEFAULT_BYTE;
                continue;
            }
            if (classArray[n].equals(Short.TYPE)) {
                objectArray[n] = DEFAULT_SHORT;
                continue;
            }
            if (classArray[n].equals(Integer.TYPE)) {
                objectArray[n] = DEFAULT_INT;
                continue;
            }
            if (classArray[n].equals(Long.TYPE)) {
                objectArray[n] = DEFAULT_LONG;
                continue;
            }
            if (classArray[n].equals(Float.TYPE)) {
                objectArray[n] = Float.valueOf(DEFAULT_FLOAT);
                continue;
            }
            if (classArray[n].equals(Double.TYPE)) {
                objectArray[n] = DEFAULT_DOUBLE;
                continue;
            }
            throw new IllegalArgumentException("Class type " + classArray[n].getName() + " not mapped to primitive default value.");
        }
        try {
            ((Method)object2).invoke((Object)this.comEventCallbackListener, objectArray);
            return;
        }
        catch (Exception exception) {
            ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
            objectArray2 = objectArray;
            int n3 = objectArray.length;
            for (int i = 0; i < n3; ++i) {
                object = objectArray2[i];
                if (object == null) {
                    arrayList.add("NULL");
                    continue;
                }
                arrayList.add(object.getClass().getName());
            }
            this.comEventCallbackListener.errorReceivingCallbackEvent("Exception invoking method " + object2 + " supplied: " + ((Object)arrayList).toString(), exception);
            return;
        }
    }

    @Override
    public Pointer getPointer() {
        return this.dispatchListener.getPointer();
    }

    @Override
    public WinNT$HRESULT GetTypeInfoCount(WinDef$UINTByReference winDef$UINTByReference) {
        return new WinNT$HRESULT(-2147467263);
    }

    @Override
    public WinNT$HRESULT GetTypeInfo(WinDef$UINT winDef$UINT, WinDef$LCID winDef$LCID, PointerByReference pointerByReference) {
        return new WinNT$HRESULT(-2147467263);
    }

    @Override
    public WinNT$HRESULT GetIDsOfNames(Guid$REFIID guid$REFIID, WString[] wStringArray, int n, WinDef$LCID winDef$LCID, OaIdl$DISPIDByReference oaIdl$DISPIDByReference) {
        return new WinNT$HRESULT(-2147467263);
    }

    @Override
    public WinNT$HRESULT Invoke(OaIdl$DISPID oaIdl$DISPID, Guid$REFIID guid$REFIID, WinDef$LCID winDef$LCID, WinDef$WORD winDef$WORD, OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference, Variant$VARIANT$ByReference variant$VARIANT$ByReference, OaIdl$EXCEPINFO$ByReference oaIdl$EXCEPINFO$ByReference, IntByReference intByReference) {
        assert (COMUtils.comIsInitialized()) : "Assumption about COM threading broken.";
        this.invokeOnThread(oaIdl$DISPID, guid$REFIID, winDef$LCID, winDef$WORD, oleAuto$DISPPARAMS$ByReference);
        return WinError.S_OK;
    }

    @Override
    public WinNT$HRESULT QueryInterface(Guid$REFIID guid$REFIID, PointerByReference pointerByReference) {
        if (pointerByReference == null) {
            return new WinNT$HRESULT(-2147467261);
        }
        if (guid$REFIID.equals((Object)this.listenedToRiid)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (guid$REFIID.getValue().equals((Object)Unknown.IID_IUNKNOWN)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (guid$REFIID.getValue().equals((Object)Dispatch.IID_IDISPATCH)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        return new WinNT$HRESULT(-2147467262);
    }

    @Override
    public int AddRef() {
        return 0;
    }

    @Override
    public int Release() {
        return 0;
    }
}

