/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.history;

import java.text.MessageFormat;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingJobHistoryPlugin
implements JobListener,
SchedulerPlugin {
    private String name;
    private String jobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String jobSuccessMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String jobFailedMessage = "Job {1}.{0} execution failed at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String jobWasVetoedMessage = "Job {1}.{0} was vetoed.  It was to be fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    public String getJobSuccessMessage() {
        return this.jobSuccessMessage;
    }

    public String getJobFailedMessage() {
        return this.jobFailedMessage;
    }

    public String getJobToBeFiredMessage() {
        return this.jobToBeFiredMessage;
    }

    public void setJobSuccessMessage(String string) {
        this.jobSuccessMessage = string;
    }

    public void setJobFailedMessage(String string) {
        this.jobFailedMessage = string;
    }

    public void setJobToBeFiredMessage(String string) {
        this.jobToBeFiredMessage = string;
    }

    public String getJobWasVetoedMessage() {
        return this.jobWasVetoedMessage;
    }

    public void setJobWasVetoedMessage(String string) {
        this.jobWasVetoedMessage = string;
    }

    @Override
    public void initialize(String string, Scheduler scheduler, ClassLoadHelper classLoadHelper) {
        this.name = string;
        scheduler.getListenerManager().addJobListener((JobListener)this, (Matcher<JobKey>)EverythingMatcher.allJobs());
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext objectArray) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Trigger trigger = objectArray.getTrigger();
        objectArray = new Object[]{objectArray.getJobDetail().getKey().getName(), objectArray.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), objectArray.getRefireCount()};
        this.getLog().info(MessageFormat.format(this.getJobToBeFiredMessage(), objectArray));
    }

    @Override
    public void jobWasExecuted(JobExecutionContext objectArray, JobExecutionException jobExecutionException) {
        Trigger trigger = objectArray.getTrigger();
        if (jobExecutionException != null) {
            if (!this.getLog().isWarnEnabled()) {
                return;
            }
            String string = jobExecutionException.getMessage();
            objectArray = new Object[]{objectArray.getJobDetail().getKey().getName(), objectArray.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), objectArray.getRefireCount(), string};
            this.getLog().warn(MessageFormat.format(this.getJobFailedMessage(), objectArray), (Throwable)jobExecutionException);
            return;
        }
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        String string = String.valueOf(objectArray.getResult());
        objectArray = new Object[]{objectArray.getJobDetail().getKey().getName(), objectArray.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), objectArray.getRefireCount(), string};
        this.getLog().info(MessageFormat.format(this.getJobSuccessMessage(), objectArray));
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext objectArray) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Trigger trigger = objectArray.getTrigger();
        objectArray = new Object[]{objectArray.getJobDetail().getKey().getName(), objectArray.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), objectArray.getRefireCount()};
        this.getLog().info(MessageFormat.format(this.getJobWasVetoedMessage(), objectArray));
    }
}

