/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import org.apache.commons.a.a;
import org.apache.commons.c.b;
import org.osjava.sj.loader.CustomSJProperties;
import org.osjava.sj.loader.IniSJProperties;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.XmlSJProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedJndiLoader
extends JndiLoader {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public FileBasedJndiLoader(Hashtable hashtable) {
        super(hashtable);
    }

    public void load(File file, Context context) {
        if ((file = new File(file.getAbsolutePath())).isDirectory()) {
            this.loadDirectory(file, context, null, "");
            return;
        }
        if (file.isFile()) {
            boolean bl = b.b((String)((String)this.environment.get("org.osjava.sj.filenameToContext")));
            if (this.isSupportedFile(file)) {
                this.loadFile(file, context, null, "", bl);
            }
            return;
        }
        this.LOGGER.warn("Not found: {}", (Object)file.getAbsolutePath());
    }

    public void load(File file, Context context, boolean bl) {
        if ((file = new File(file.getAbsolutePath())).isDirectory()) {
            this.loadDirectory(file, context, null, "");
            return;
        }
        if (file.isFile()) {
            this.loadFile(file, context, null, "", bl);
            return;
        }
        this.LOGGER.warn("Not found: {}", (Object)file.getAbsolutePath());
    }

    private void loadDirectory(File fileArray, Context context, Context context2, String string) {
        this.LOGGER.debug("Loading {}", (Object)fileArray.getAbsolutePath());
        fileArray = fileArray.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                boolean bl;
                String string2;
                if (file.isDirectory()) {
                    string2 = file.getName();
                    if (string2.equals(".svn") || string2.equals("CVS")) continue;
                    string2 = this.handleColonReplacement(string2);
                    Context context3 = context.createSubcontext(string2);
                    this.loadDirectory(file, context3, context, string2);
                    continue;
                }
                string2 = a.a((String)file.getName());
                boolean bl2 = bl = !string2.equals("default");
                if (!this.isSupportedFile(file)) continue;
                this.loadFile(file, context, context2, string, bl);
            }
        }
    }

    private void loadFile(File serializable, Context context, Context context2, String string, boolean bl) {
        this.LOGGER.debug("Loading {}", (Object)serializable.getAbsolutePath());
        String string2 = serializable.getName();
        string2 = this.handleColonReplacement(string2);
        Context context3 = context;
        serializable = this.toProperties((File)serializable);
        if (this.isNotNamespacedTypeDefinition((Properties)serializable)) {
            string = a.a((String)string2);
            context2 = context3;
        } else if (!a.a((String)string2).equals("default")) {
            string2 = a.a((String)string2);
            if (bl) {
                context3 = context.createSubcontext(string2);
                context2 = context;
            }
            string = string2;
        }
        this.load((Properties)serializable, context3, context2, string);
    }

    public Properties toProperties(File object) {
        Serializable serializable = ((File)object).getName().endsWith(".xml") ? new XmlSJProperties() : (((File)object).getName().endsWith(".ini") ? new IniSJProperties() : new CustomSJProperties());
        serializable.setDelimiter((String)this.environment.get("org.osjava.sj.delimiter"));
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            ((Properties)serializable).load((InputStream)object);
            return serializable;
        }
        catch (Throwable throwable2) {
            serializable = throwable2;
            throwable = throwable2;
            throw serializable;
        }
        finally {
            if (throwable != null) {
                try {
                    ((FileInputStream)object).close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            } else {
                ((FileInputStream)object).close();
            }
        }
    }
}

