/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import org.apache.commons.a.a;
import org.osjava.sj.loader.CustomSJProperties;
import org.osjava.sj.loader.IniSJProperties;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.NioBasedJndiLoader$MySimpleFileVisitor;
import org.osjava.sj.loader.XmlSJProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioBasedJndiLoader
extends JndiLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(NioBasedJndiLoader.class);

    public NioBasedJndiLoader(Hashtable hashtable) {
        super(hashtable);
    }

    public void load(File file, Context context, boolean bl) {
        if ((file = new File(file.getAbsolutePath())).isDirectory()) {
            File file2 = file;
            this.loadDirectory(file2, file2.getPath(), context, null, "");
            return;
        }
        this.loadFile(file.toPath(), context, null, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadJar(File object, String object2, Context context, boolean bl) {
        block9: {
            object = Paths.get(((File)object).toURI());
            object = FileSystems.newFileSystem((Path)object, null);
            Throwable throwable = null;
            try {
                Files.walkFileTree(((FileSystem)object).getPath((String)object2, new String[0]), new NioBasedJndiLoader$MySimpleFileVisitor(this, (String)object2, context, "", bl));
                if (object == null) return;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable4) {
                    if (object == null) throw throwable4;
                    if (throwable == null) {
                        ((FileSystem)object).close();
                        throw throwable4;
                    }
                    try {
                        ((FileSystem)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                ((FileSystem)object).close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        ((FileSystem)object).close();
    }

    private void loadFile(Path object, Context context, Context context2, boolean bl) {
        LOGGER.debug("Loading {}", object);
        String string = object.getFileName().toString();
        string = this.handleColonReplacement(string);
        Context context3 = context;
        object = this.toProperties((Path)object);
        String string2 = null;
        if (this.isNotNamespacedTypeDefinition((Properties)object)) {
            string2 = a.a((String)string);
            context2 = context3;
        } else if (!a.a((String)string).equals("default")) {
            string = a.a((String)string);
            if (bl) {
                context3 = context.createSubcontext(string);
                context2 = context;
            }
            string2 = string;
        }
        this.load((Properties)object, context3, context2, string2);
    }

    public Properties toProperties(Path object) {
        Serializable serializable = object.getFileName().toString().endsWith(".xml") ? new XmlSJProperties() : (object.getFileName().toString().endsWith(".ini") ? new IniSJProperties() : new CustomSJProperties());
        serializable.setDelimiter((String)this.environment.get("org.osjava.sj.delimiter"));
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        Throwable throwable = null;
        try {
            ((Properties)serializable).load((InputStream)object);
            return serializable;
        }
        catch (Throwable throwable2) {
            serializable = throwable2;
            throwable = throwable2;
            throw serializable;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
    }

    private void loadDirectory(File file, String string, Context context, Context context2, String string2) {
        Files.walkFileTree(file.toPath(), new NioBasedJndiLoader$MySimpleFileVisitor(this, string, context, "", false));
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ void access$100(NioBasedJndiLoader nioBasedJndiLoader, Path path, Context context, Context context2, boolean bl) {
        nioBasedJndiLoader.loadFile(path, context, context2, bl);
    }
}

