/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.apache.commons.c.c;
import org.osjava.a;
import org.osjava.sj.loader.convert.ConverterIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConverter
implements ConverterIF {
    private static Logger LOGGER = LoggerFactory.getLogger(BeanConverter.class);

    private static PropertyDescriptor findPropertyDescriptorWithSetter(Class<?> clazz, String string) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz, Object.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray.getPropertyDescriptors()) {
                Method method;
                if (!propertyDescriptor.getName().equalsIgnoreCase(string) || (method = propertyDescriptor.getWriteMethod()) == null) continue;
                return propertyDescriptor;
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("Unable to find the properties of the bean of type, \"" + clazz + "\".", introspectionException);
        }
        return null;
    }

    private static Object convert(String string, Class<?> clazz) {
        Object object;
        if (String.class.equals(clazz)) {
            object = string;
        } else if (CharSequence.class.equals(clazz)) {
            object = string;
        } else {
            object = string.trim();
            if (((String)object).isEmpty() && !clazz.isPrimitive()) {
                object = null;
            } else if (((String)object).length() == 0 && !clazz.isPrimitive()) {
                object = null;
            } else if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
                object = a.a((String)object);
            } else if (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz)) {
                object = org.apache.commons.c.a.a.e((String)object);
            } else if (Character.TYPE.equals(clazz) || Character.class.equals(clazz)) {
                object = Character.valueOf(a.f((String)object));
            } else if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
                object = org.apache.commons.c.a.a.f((String)object);
            } else if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
                object = org.apache.commons.c.a.a.a((String)object);
            } else if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
                object = org.apache.commons.c.a.a.b((String)object);
            } else if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
                object = Float.valueOf(org.apache.commons.c.a.a.c((String)object));
            } else if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
                object = org.apache.commons.c.a.a.d((String)object);
            } else if (java.util.Date.class.equals(clazz)) {
                object = a.e((String)object);
            } else if (Date.class.equals(clazz)) {
                object = a.d((String)object);
            } else if (Time.class.equals(clazz)) {
                object = a.c((String)object);
            } else if (Timestamp.class.equals(clazz)) {
                object = a.b((String)object);
            } else if (clazz.isEnum()) {
                object = a.c(clazz, (String)object);
            } else if ((object = a.a(clazz, (String)object)) == c.a) {
                object = a.b(clazz, string);
            }
        }
        return object;
    }

    @Override
    public Object convert(Properties properties, String string) {
        String string2 = properties.getProperty("");
        if (string2 != null) {
            throw new RuntimeException("Specify the value as a pseudo property as Beans have empty constructors");
        }
        string2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            for (Object object : properties.keySet()) {
                GenericDeclaration genericDeclaration;
                Object object2;
                if ("converter".equals(object = (String)object) || "type".equals(object)) continue;
                Object object3 = properties.get(object);
                if (object3 instanceof String) {
                    object2 = (String)object3;
                    PropertyDescriptor propertyDescriptor = BeanConverter.findPropertyDescriptorWithSetter(clazz, (String)object);
                    if (propertyDescriptor == null) {
                        throw new RuntimeException("No property with the name of \"" + (String)object + "\" could be found on object of type, \"" + clazz + "\".");
                    }
                    genericDeclaration = propertyDescriptor.getPropertyType();
                    Method method = propertyDescriptor.getWriteMethod();
                    method.invoke(obj, BeanConverter.convert((String)object2, genericDeclaration));
                    continue;
                }
                if (object3 instanceof List) {
                    object2 = (List)object3;
                    int n = object2.size();
                    object = "add" + Character.toTitleCase(((String)object).charAt(0)) + ((String)object).substring(1);
                    genericDeclaration = clazz.getMethod((String)object, Integer.TYPE, String.class);
                    for (int i = 0; i < n; ++i) {
                        Object e = object2.get(i);
                        if (!(e instanceof String)) {
                            LOGGER.error("Processing List: properties={} type={} property={} key={} item={}", new Object[]{properties, string, object3, object, e});
                            throw new RuntimeException("Only Strings and Lists of String are supported");
                        }
                        ((Method)genericDeclaration).invoke(obj, i, e);
                    }
                    continue;
                }
                LOGGER.error("Processing List: properties={} type={} methodName={} property={} key={}", new Object[]{properties, string, string2, object3, object});
                throw new RuntimeException("Only Strings and Lists of Strings are supported");
            }
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unable to find class: " + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Unable to find method " + string2 + " on class: " + string, noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Unable to instantiate class: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unable to access class: " + string, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Unable to pass argument to class: " + string, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Unable to invoke (String) constructor on class: " + string, invocationTargetException);
        }
    }
}

