/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationWatchList
extends ContextAwareBase {
    URL mainURL;
    List<File> fileWatchList = new ArrayList<File>();
    List<Long> lastModifiedList = new ArrayList<Long>();

    public ConfigurationWatchList buildClone() {
        ConfigurationWatchList configurationWatchList = new ConfigurationWatchList();
        new ConfigurationWatchList().mainURL = this.mainURL;
        configurationWatchList.fileWatchList = new ArrayList<File>(this.fileWatchList);
        configurationWatchList.lastModifiedList = new ArrayList<Long>(this.lastModifiedList);
        return configurationWatchList;
    }

    public void clear() {
        this.mainURL = null;
        this.lastModifiedList.clear();
        this.fileWatchList.clear();
    }

    public void setMainURL(URL uRL) {
        this.mainURL = uRL;
        if (uRL != null) {
            this.addAsFileToWatch(uRL);
        }
    }

    private void addAsFileToWatch(URL serializable) {
        if ((serializable = this.convertToFile((URL)serializable)) != null) {
            this.fileWatchList.add((File)serializable);
            this.lastModifiedList.add(((File)serializable).lastModified());
        }
    }

    public void addToWatchList(URL uRL) {
        this.addAsFileToWatch(uRL);
    }

    public URL getMainURL() {
        return this.mainURL;
    }

    public List<File> getCopyOfFileWatchList() {
        return new ArrayList<File>(this.fileWatchList);
    }

    public boolean changeDetected() {
        int n = this.fileWatchList.size();
        for (int i = 0; i < n; ++i) {
            File file;
            long l = this.lastModifiedList.get(i);
            if (l == (file = this.fileWatchList.get(i)).lastModified()) continue;
            return true;
        }
        return false;
    }

    File convertToFile(URL uRL) {
        String string = uRL.getProtocol();
        if ("file".equals(string)) {
            return new File(URLDecoder.decode(uRL.getFile()));
        }
        this.addInfo("URL [" + String.valueOf(uRL) + "] is not of type file");
        return null;
    }
}

