/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.lang.reflect.AnnotatedElement;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.JvmUtilsKt;
import org.jetbrains.skiko.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/skiko/InternalSunApiChecker;", "", "()V", "hasCheckedAccess", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSunFontAccessible", "canAccessSunFontApi", "", "isSunFontApiAccessible", "logInstructions", "", "logJbrWarning", "skiko"})
public final class InternalSunApiChecker {
    public static final InternalSunApiChecker INSTANCE = new InternalSunApiChecker();
    private static AtomicBoolean hasCheckedAccess = new AtomicBoolean(false);
    private static AtomicBoolean isSunFontAccessible = new AtomicBoolean(false);

    private InternalSunApiChecker() {
    }

    public final boolean isSunFontApiAccessible() {
        boolean bl;
        if (hasCheckedAccess.get()) {
            return isSunFontAccessible.get();
        }
        if (!JvmUtilsKt.isRunningOnJetBrainsRuntime()) {
            this.logJbrWarning();
        }
        if (!(bl = this.canAccessSunFontApi())) {
            this.logInstructions();
        }
        isSunFontAccessible.set(bl);
        hasCheckedAccess.set(true);
        return bl;
    }

    private final boolean canAccessSunFontApi() {
        try {
            Object object = ClassLoader.getSystemClassLoader().getUnnamedModule();
            Set<Module> set = ModuleLayer.boot().modules();
            Intrinsics.checkNotNullExpressionValue(set, (String)"");
            AnnotatedElement annotatedElement = set;
            Object var3_3 = null;
            boolean bl = false;
            annotatedElement = annotatedElement.iterator();
            while (annotatedElement.hasNext()) {
                Object e = annotatedElement.next();
                Module module = (Module)e;
                if (!Intrinsics.areEqual((Object)module.getName(), (Object)"java.desktop")) continue;
                if (bl) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                var3_3 = e;
                bl = true;
            }
            if (!bl) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            annotatedElement = var3_3;
            if (!((Module)object).canRead((Module)annotatedElement)) {
                return false;
            }
            if (!((Module)annotatedElement).isOpen("sun.font", (Module)object)) {
                return false;
            }
            annotatedElement = Class.forName("sun.font.FontManagerFactory");
            annotatedElement.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            object = Logger.INSTANCE;
            if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
                object = ((Logger)object).getLoggerImpl();
                object.debug("Sun Font APIs are accessible, advanced font features are available");
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private final void logJbrWarning() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isWarnEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.warn("The Java Runtime in use may not support all advanced Skiko features.\nIt is recommended that you run this app on the JetBrains Runtime for\nbest results.");
        }
    }

    private final void logInstructions() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isErrorEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.error("\n!!! WARNING !!!\nFor Skiko to run optimally, you should add the following argument\nto the command for this program:\n\n--add-opens java.desktop/sun.font=ALL-UNNAMED \n\nThis is required to be able to properly match the Skia fonts with\nthe AWT fonts and access private JDK APIs used for some advanced\nfeatures.");
        }
    }
}

