/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger$CompletedExecutionInstruction;
import org.quartz.core.JobRunShell$VetoedException;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.JobExecutionContextImpl;
import org.quartz.listeners.SchedulerListenerSupport;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunShell
extends SchedulerListenerSupport
implements Runnable {
    protected JobExecutionContextImpl jec = null;
    protected QuartzScheduler qs = null;
    protected TriggerFiredBundle firedTriggerBundle = null;
    protected Scheduler scheduler = null;
    protected volatile boolean shutdownRequested = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JobRunShell(Scheduler scheduler, TriggerFiredBundle triggerFiredBundle) {
        this.scheduler = scheduler;
        this.firedTriggerBundle = triggerFiredBundle;
    }

    @Override
    public void schedulerShuttingdown() {
        this.requestShutdown();
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    public void initialize(QuartzScheduler quartzScheduler) {
        Job job;
        this.qs = quartzScheduler;
        JobDetail jobDetail = this.firedTriggerBundle.getJobDetail();
        try {
            job = quartzScheduler.getJobFactory().newJob(this.firedTriggerBundle, this.scheduler);
        }
        catch (SchedulerException schedulerException) {
            quartzScheduler.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getKey() + "'", schedulerException);
            throw schedulerException;
        }
        catch (Throwable throwable) {
            SchedulerException schedulerException = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "' - ", throwable);
            quartzScheduler.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getKey() + "'", schedulerException);
            throw schedulerException;
        }
        this.jec = new JobExecutionContextImpl(this.scheduler, this.firedTriggerBundle, job);
    }

    public void requestShutdown() {
        this.shutdownRequested = true;
    }

    @Override
    public void run() {
        this.qs.addInternalSchedulerListener(this);
        try {
            block22: {
                Object object;
                OperableTrigger operableTrigger = (OperableTrigger)this.jec.getTrigger();
                JobDetail jobDetail = this.jec.getJobDetail();
                while (true) {
                    long l;
                    SchedulerException schedulerException;
                    block23: {
                        schedulerException = null;
                        object = this.jec.getJobInstance();
                        try {
                            this.begin();
                        }
                        catch (SchedulerException schedulerException2) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getKey() + ": couldn't begin execution.", schedulerException2);
                            break block22;
                        }
                        try {
                            JobRunShell jobRunShell = this;
                            if (!jobRunShell.notifyListenersBeginning(jobRunShell.jec)) {
                            }
                            break block23;
                        }
                        catch (JobRunShell$VetoedException jobRunShell$VetoedException) {
                            try {
                                Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction = operableTrigger.executionComplete(this.jec, null);
                                this.qs.notifyJobStoreJobVetoed(operableTrigger, jobDetail, trigger$CompletedExecutionInstruction);
                                if (this.jec.getTrigger().getNextFireTime() == null) {
                                    this.qs.notifySchedulerListenersFinalized(this.jec.getTrigger());
                                }
                                this.complete(true);
                                break block22;
                            }
                            catch (SchedulerException schedulerException3) {
                                this.qs.notifySchedulerListenersError("Error during veto of Job (" + this.jec.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException3);
                            }
                        }
                        break block22;
                    }
                    long l2 = System.currentTimeMillis();
                    try {
                        this.log.debug("Calling execute on job " + jobDetail.getKey());
                        object.execute(this.jec);
                        l = System.currentTimeMillis();
                    }
                    catch (JobExecutionException jobExecutionException) {
                        l = System.currentTimeMillis();
                        schedulerException = jobExecutionException;
                        this.getLog().info("Job " + jobDetail.getKey() + " threw a JobExecutionException: ", (Throwable)schedulerException);
                    }
                    catch (Throwable throwable) {
                        l = System.currentTimeMillis();
                        this.getLog().error("Job " + jobDetail.getKey() + " threw an unhandled Exception: ", throwable);
                        schedulerException = new SchedulerException("Job threw an unhandled exception.", throwable);
                        this.qs.notifySchedulerListenersError("Job (" + this.jec.getJobDetail().getKey() + " threw an exception.", schedulerException);
                        schedulerException = new JobExecutionException(schedulerException, false);
                    }
                    this.jec.setJobRunTime(l - l2);
                    JobRunShell jobRunShell = this;
                    if (!jobRunShell.notifyJobListenersComplete(jobRunShell.jec, (JobExecutionException)schedulerException)) break block22;
                    object = Trigger$CompletedExecutionInstruction.NOOP;
                    try {
                        object = operableTrigger.executionComplete(this.jec, (JobExecutionException)schedulerException);
                    }
                    catch (Exception exception) {
                        schedulerException = new SchedulerException("Trigger threw an unhandled exception.", exception);
                        this.qs.notifySchedulerListenersError("Please report this error to the Quartz developers.", schedulerException);
                    }
                    JobRunShell jobRunShell2 = this;
                    if (!jobRunShell2.notifyTriggerListenersComplete(jobRunShell2.jec, (Trigger$CompletedExecutionInstruction)((Object)object))) break block22;
                    if (object == Trigger$CompletedExecutionInstruction.RE_EXECUTE_JOB) {
                        this.jec.incrementRefireCount();
                        try {
                            this.complete(false);
                        }
                        catch (SchedulerException schedulerException4) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException4);
                        }
                        continue;
                    }
                    try {
                        this.complete(true);
                    }
                    catch (SchedulerException schedulerException5) {
                        this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException5);
                        continue;
                    }
                    break;
                }
                this.qs.notifyJobStoreJobComplete(operableTrigger, jobDetail, (Trigger$CompletedExecutionInstruction)((Object)object));
            }
            return;
        }
        finally {
            this.qs.removeInternalSchedulerListener(this);
        }
    }

    protected void begin() {
    }

    protected void complete(boolean bl) {
    }

    public void passivate() {
        this.jec = null;
        this.qs = null;
    }

    private boolean notifyListenersBeginning(JobExecutionContext jobExecutionContext) {
        boolean bl;
        try {
            bl = this.qs.notifyTriggerListenersFired(jobExecutionContext);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        if (bl) {
            try {
                this.qs.notifyJobListenersWasVetoed(jobExecutionContext);
            }
            catch (SchedulerException schedulerException) {
                this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of vetoed execution while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            }
            throw new JobRunShell$VetoedException();
        }
        try {
            this.qs.notifyJobListenersToBeExecuted(jobExecutionContext);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        return true;
    }

    private boolean notifyJobListenersComplete(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        try {
            this.qs.notifyJobListenersWasExecuted(jobExecutionContext, jobExecutionException);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        return true;
    }

    private boolean notifyTriggerListenersComplete(JobExecutionContext jobExecutionContext, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        try {
            this.qs.notifyTriggerListenersComplete(jobExecutionContext, trigger$CompletedExecutionInstruction);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        if (jobExecutionContext.getTrigger().getNextFireTime() == null) {
            this.qs.notifySchedulerListenersFinalized(jobExecutionContext.getTrigger());
        }
        return true;
    }
}

