/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.Trigger$TriggerState;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;

public class RemoteScheduler
implements Scheduler {
    private RemotableQuartzScheduler rsched;
    private String schedId;
    private String rmiHost;
    private int rmiPort;

    public RemoteScheduler(String string, String string2, int n) {
        this.schedId = string;
        this.rmiHost = string2;
        this.rmiPort = n;
    }

    protected RemotableQuartzScheduler getRemoteScheduler() {
        if (this.rsched != null) {
            return this.rsched;
        }
        try {
            Registry registry = LocateRegistry.getRegistry(this.rmiHost, this.rmiPort);
            this.rsched = (RemotableQuartzScheduler)registry.lookup(this.schedId);
        }
        catch (Exception exception) {
            SchedulerException schedulerException = new SchedulerException("Could not get handle to remote scheduler: " + exception.getMessage(), exception);
            throw schedulerException;
        }
        return this.rsched;
    }

    protected SchedulerException invalidateHandleCreateException(String object, Exception exception) {
        this.rsched = null;
        object = new SchedulerException((String)object, exception);
        return object;
    }

    @Override
    public String getSchedulerName() {
        try {
            return this.getRemoteScheduler().getSchedulerName();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public String getSchedulerInstanceId() {
        try {
            return this.getRemoteScheduler().getSchedulerInstanceId();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public SchedulerMetaData getMetaData() {
        try {
            RemotableQuartzScheduler remotableQuartzScheduler = this.getRemoteScheduler();
            return new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), true, this.isStarted(), this.isInStandbyMode(), this.isShutdown(), remotableQuartzScheduler.runningSince(), remotableQuartzScheduler.numJobsExecuted(), remotableQuartzScheduler.getJobStoreClass(), remotableQuartzScheduler.supportsPersistence(), remotableQuartzScheduler.isClustered(), remotableQuartzScheduler.getThreadPoolClass(), remotableQuartzScheduler.getThreadPoolSize(), remotableQuartzScheduler.getVersion());
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public SchedulerContext getContext() {
        try {
            return this.getRemoteScheduler().getSchedulerContext();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void start() {
        try {
            this.getRemoteScheduler().start();
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void startDelayed(int n) {
        try {
            this.getRemoteScheduler().startDelayed(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void standby() {
        try {
            this.getRemoteScheduler().standby();
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean isStarted() {
        try {
            return this.getRemoteScheduler().runningSince() != null;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean isInStandbyMode() {
        try {
            return this.getRemoteScheduler().isInStandbyMode();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void shutdown() {
        try {
            String string = this.getSchedulerName();
            this.getRemoteScheduler().shutdown();
            SchedulerRepository.getInstance().remove(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void shutdown(boolean bl) {
        try {
            String string = this.getSchedulerName();
            this.getRemoteScheduler().shutdown(bl);
            SchedulerRepository.getInstance().remove(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean isShutdown() {
        try {
            return this.getRemoteScheduler().isShutdown();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() {
        try {
            return this.getRemoteScheduler().getCurrentlyExecutingJobs();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) {
        try {
            return this.getRemoteScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Date scheduleJob(Trigger trigger) {
        try {
            return this.getRemoteScheduler().scheduleJob(trigger);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl) {
        try {
            this.getRemoteScheduler().addJob(jobDetail, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl, boolean bl2) {
        try {
            this.getRemoteScheduler().addJob(jobDetail, bl, bl2);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean deleteJobs(List<JobKey> list) {
        try {
            return this.getRemoteScheduler().deleteJobs(list);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) {
        try {
            this.getRemoteScheduler().scheduleJobs(map, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> set, boolean bl) {
        try {
            this.getRemoteScheduler().scheduleJob(jobDetail, set, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> list) {
        try {
            return this.getRemoteScheduler().unscheduleJobs(list);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean deleteJob(JobKey jobKey) {
        try {
            return this.getRemoteScheduler().deleteJob(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) {
        try {
            return this.getRemoteScheduler().unscheduleJob(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, Trigger trigger) {
        try {
            return this.getRemoteScheduler().rescheduleJob(triggerKey, trigger);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void triggerJob(JobKey jobKey) {
        this.triggerJob(jobKey, null);
    }

    @Override
    public void triggerJob(JobKey jobKey, JobDataMap jobDataMap) {
        try {
            this.getRemoteScheduler().triggerJob(jobKey, jobDataMap);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        try {
            this.getRemoteScheduler().pauseTrigger(triggerKey);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        try {
            this.getRemoteScheduler().pauseTriggers(groupMatcher);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) {
        try {
            this.getRemoteScheduler().pauseJob(jobKey);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        try {
            this.getRemoteScheduler().pauseJobs(groupMatcher);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        try {
            this.getRemoteScheduler().resumeTrigger(triggerKey);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        try {
            this.getRemoteScheduler().resumeTriggers(groupMatcher);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeJob(JobKey jobKey) {
        try {
            this.getRemoteScheduler().resumeJob(jobKey);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        try {
            this.getRemoteScheduler().resumeJobs(groupMatcher);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void pauseAll() {
        try {
            this.getRemoteScheduler().pauseAll();
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resumeAll() {
        try {
            this.getRemoteScheduler().resumeAll();
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<String> getJobGroupNames() {
        try {
            return this.getRemoteScheduler().getJobGroupNames();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) {
        try {
            return this.getRemoteScheduler().getJobKeys(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<? extends Trigger> getTriggersOfJob(JobKey jobKey) {
        try {
            return this.getRemoteScheduler().getTriggersOfJob(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<String> getTriggerGroupNames() {
        try {
            return this.getRemoteScheduler().getTriggerGroupNames();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        try {
            return this.getRemoteScheduler().getTriggerKeys(groupMatcher);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) {
        try {
            return this.getRemoteScheduler().getJobDetail(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean checkExists(JobKey jobKey) {
        try {
            return this.getRemoteScheduler().checkExists(jobKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) {
        try {
            return this.getRemoteScheduler().checkExists(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void clear() {
        try {
            this.getRemoteScheduler().clear();
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Trigger getTrigger(TriggerKey triggerKey) {
        try {
            return this.getRemoteScheduler().getTrigger(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Trigger$TriggerState getTriggerState(TriggerKey triggerKey) {
        try {
            return this.getRemoteScheduler().getTriggerState(triggerKey);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        try {
            this.getRemoteScheduler().resetTriggerFromErrorState(triggerKey);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public void addCalendar(String string, Calendar calendar, boolean bl, boolean bl2) {
        try {
            this.getRemoteScheduler().addCalendar(string, calendar, bl, bl2);
            return;
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public boolean deleteCalendar(String string) {
        try {
            return this.getRemoteScheduler().deleteCalendar(string);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Calendar getCalendar(String string) {
        try {
            return this.getRemoteScheduler().getCalendar(string);
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public List<String> getCalendarNames() {
        try {
            return this.getRemoteScheduler().getCalendarNames();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() {
        try {
            return this.getRemoteScheduler().getPausedTriggerGroups();
        }
        catch (RemoteException remoteException) {
            throw this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException);
        }
    }

    @Override
    public ListenerManager getListenerManager() {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean interrupt(JobKey jobKey) {
        try {
            return this.getRemoteScheduler().interrupt(jobKey);
        }
        catch (RemoteException remoteException) {
            throw new UnableToInterruptJobException(this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException));
        }
        catch (SchedulerException schedulerException) {
            throw new UnableToInterruptJobException(schedulerException);
        }
    }

    @Override
    public boolean interrupt(String string) {
        try {
            return this.getRemoteScheduler().interrupt(string);
        }
        catch (RemoteException remoteException) {
            throw new UnableToInterruptJobException(this.invalidateHandleCreateException("Error communicating with remote scheduler.", remoteException));
        }
        catch (SchedulerException schedulerException) {
            throw new UnableToInterruptJobException(schedulerException);
        }
    }

    @Override
    public void setJobFactory(JobFactory jobFactory) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }
}

