/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate$TriggerPropertyBundle;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.quartz.utils.Key;

public class CronTriggerPersistenceDelegate
implements StdJDBCConstants,
TriggerPersistenceDelegate {
    protected String tablePrefix;
    protected String schedNameLiteral;

    @Override
    public void initialize(String string, String string2) {
        this.tablePrefix = string;
        this.schedNameLiteral = "'" + string2 + "'";
    }

    @Override
    public String getHandledTriggerTypeDiscriminator() {
        return "CRON";
    }

    @Override
    public boolean canHandleTriggerType(OperableTrigger operableTrigger) {
        return operableTrigger instanceof CronTriggerImpl && !((CronTriggerImpl)operableTrigger).hasAdditionalProperties();
    }

    @Override
    public int deleteExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int insertExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String object, JobDetail object2) {
        object = (CronTrigger)((Object)operableTrigger);
        object2 = null;
        try {
            object2 = connection.prepareStatement(Util.rtp("INSERT INTO {0}CRON_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES({1}, ?, ?, ?, ?)", this.tablePrefix, this.schedNameLiteral));
            object2.setString(1, operableTrigger.getKey().getName());
            object2.setString(2, operableTrigger.getKey().getGroup());
            object2.setString(3, object.getCronExpression());
            object2.setString(4, object.getTimeZone().getID());
            int n = object2.executeUpdate();
            return n;
        }
        finally {
            Util.closeStatement((Statement)object2);
        }
    }

    @Override
    public TriggerPersistenceDelegate$TriggerPropertyBundle loadExtendedTriggerProperties(Connection object, TriggerKey object2) {
        block4: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = object.prepareStatement(Util.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
                preparedStatement.setString(1, ((Key)object2).getName());
                preparedStatement.setString(2, ((Key)object2).getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                object = resultSet.getString("CRON_EXPRESSION");
                object2 = resultSet.getString("TIME_ZONE_ID");
                object = CronScheduleBuilder.cronSchedule((String)object);
                if (object2 != null) {
                    ((CronScheduleBuilder)object).inTimeZone(TimeZone.getTimeZone((String)object2));
                }
                object = new TriggerPersistenceDelegate$TriggerPropertyBundle((ScheduleBuilder<?>)object, null, null);
            }
            catch (Throwable throwable) {
                Util.closeResultSet(resultSet);
                Util.closeStatement(preparedStatement);
                throw throwable;
            }
            Util.closeResultSet(resultSet);
            Util.closeStatement(preparedStatement);
            return object;
        }
        throw new IllegalStateException("No record found for selection of Trigger with key: '" + object2 + "' and statement: " + Util.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
    }

    @Override
    public int updateExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String object, JobDetail object2) {
        object = (CronTrigger)((Object)operableTrigger);
        object2 = null;
        try {
            object2 = connection.prepareStatement(Util.rtp("UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ?, TIME_ZONE_ID = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            object2.setString(1, object.getCronExpression());
            object2.setString(2, object.getTimeZone().getID());
            object2.setString(3, operableTrigger.getKey().getName());
            object2.setString(4, operableTrigger.getKey().getGroup());
            int n = object2.executeUpdate();
            return n;
        }
        finally {
            Util.closeStatement((Statement)object2);
        }
    }
}

