/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.interrupt;

import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobInterruptMonitorPlugin$InterruptMonitor
implements Runnable {
    private final JobKey jobKey;
    private final Scheduler scheduler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    JobInterruptMonitorPlugin$InterruptMonitor(JobKey jobKey, Scheduler scheduler) {
        this.jobKey = jobKey;
        this.scheduler = scheduler;
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void run() {
        try {
            this.getLog().info("Interrupting Job as it ran more than the configured max time. Job Details [" + this.jobKey.getName() + ":" + this.jobKey.getGroup() + "]");
            this.scheduler.interrupt(this.jobKey);
            return;
        }
        catch (SchedulerException schedulerException) {
            this.getLog().info("Error interrupting Job: " + schedulerException.getMessage(), (Throwable)schedulerException);
            return;
        }
    }
}

