/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.sanity;

import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.joran.sanity.Pair;
import ch.qos.logback.core.joran.sanity.SanityChecker;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.ArrayList;
import java.util.List;

public class IfNestedWithinSecondPhaseElementSC
extends ContextAwareBase
implements SanityChecker {
    public static final String NESTED_IF_WARNING_URL = "http://logback.qos.ch/codes.html#nested_if_element";

    public void check(Model object) {
        if (object == null) {
            return;
        }
        Pair pair = new ArrayList();
        this.deepFindAllModelsOfType(AppenderModel.class, (List)pair, (Model)object);
        this.deepFindAllModelsOfType(LoggerModel.class, (List)pair, (Model)object);
        this.deepFindAllModelsOfType(RootLoggerModel.class, (List)pair, (Model)object);
        object = this.deepFindNestedSubModelsOfType(IfModel.class, (List)pair);
        if (object.isEmpty()) {
            return;
        }
        this.addWarn("<if> elements cannot be nested within an <appender>, <logger> or <root> element");
        this.addWarn("See also http://logback.qos.ch/codes.html#nested_if_element");
        object = object.iterator();
        while (object.hasNext()) {
            pair = (Pair)object.next();
            Model model = (Model)pair.first;
            int n = model.getLineNumber();
            pair = (Model)pair.second;
            int n2 = pair.getLineNumber();
            this.addWarn("Element <" + model.getTag() + "> at line " + n + " contains a nested <" + pair.getTag() + "> element at line " + n2);
        }
    }

    public String toString() {
        return "IfNestedWithinSecondPhaseElementSC";
    }
}

