/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public class Jdk13LumberjackLogger
implements Serializable,
Log {
    private static final long serialVersionUID = -8649807923527610591L;
    protected transient Logger logger = null;
    protected String name = null;
    private String sourceClassName = "unknown";
    private String sourceMethodName = "unknown";
    private boolean classAndMethodFound = false;
    protected static final Level dummyLevel = Level.FINE;

    public Jdk13LumberjackLogger(String string) {
        this.name = string;
        this.logger = this.getLogger();
    }

    private void log(Level serializable, String string, Throwable throwable) {
        if (this.getLogger().isLoggable((Level)serializable)) {
            serializable = new LogRecord((Level)serializable, string);
            if (!this.classAndMethodFound) {
                this.getClassAndMethod();
            }
            ((LogRecord)serializable).setSourceClassName(this.sourceClassName);
            ((LogRecord)serializable).setSourceMethodName(this.sourceMethodName);
            if (throwable != null) {
                ((LogRecord)serializable).setThrown(throwable);
            }
            this.getLogger().log((LogRecord)serializable);
        }
    }

    private void getClassAndMethod() {
        try {
            Object object = new Throwable();
            ((Throwable)object).fillInStackTrace();
            Object object2 = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object2);
            ((Throwable)object).printStackTrace(printWriter);
            object = ((StringWriter)object2).getBuffer().toString();
            object = new StringTokenizer((String)object, "\n");
            ((StringTokenizer)object).nextToken();
            object2 = ((StringTokenizer)object).nextToken();
            while (((String)object2).indexOf(this.getClass().getName()) == -1) {
                object2 = ((StringTokenizer)object).nextToken();
            }
            while (((String)object2).indexOf(this.getClass().getName()) >= 0) {
                object2 = ((StringTokenizer)object).nextToken();
            }
            int n = ((String)object2).indexOf("at ") + 3;
            int n2 = ((String)object2).indexOf(40);
            String string = ((String)object2).substring(n, n2);
            int n3 = string.lastIndexOf(46);
            this.sourceClassName = string.substring(0, n3);
            this.sourceMethodName = string.substring(n3 + 1);
        }
        catch (Exception exception) {}
        this.classAndMethodFound = true;
    }

    public void debug(Object object) {
        this.log(Level.FINE, String.valueOf(object), null);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(Level.FINE, String.valueOf(object), throwable);
    }

    public void error(Object object) {
        this.log(Level.SEVERE, String.valueOf(object), null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(Level.SEVERE, String.valueOf(object), throwable);
    }

    public void fatal(Object object) {
        this.log(Level.SEVERE, String.valueOf(object), null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(Level.SEVERE, String.valueOf(object), throwable);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        return this.logger;
    }

    public void info(Object object) {
        this.log(Level.INFO, String.valueOf(object), null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(Level.INFO, String.valueOf(object), throwable);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    public void trace(Object object) {
        this.log(Level.FINEST, String.valueOf(object), null);
    }

    public void trace(Object object, Throwable throwable) {
        this.log(Level.FINEST, String.valueOf(object), throwable);
    }

    public void warn(Object object) {
        this.log(Level.WARNING, String.valueOf(object), null);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(Level.WARNING, String.valueOf(object), throwable);
    }
}

