/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FileSystemException;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FileTreeWalkKt;
import kotlin.io.FilesKt__UtilsKt$copyRecursively$1;
import kotlin.io.FilesKt__UtilsKt$copyRecursively$2;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u001a*\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0007\u001a*\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0007\u001a8\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\u001a\b\u0002\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u001a&\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u000f*\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0002*\u00020\u0002\u001a\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d*\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0011\u0010\u001c\u001a\u00020\u001f*\u00020\u001fH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0012\u0010 \u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010#\u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u001b\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\b*\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006+"}, d2={"extension", "", "Ljava/io/File;", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath", "nameWithoutExtension", "getNameWithoutExtension", "createTempDir", "prefix", "suffix", "directory", "createTempFile", "copyRecursively", "", "target", "overwrite", "onError", "Lkotlin/Function2;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "copyTo", "bufferSize", "", "deleteRecursively", "endsWith", "other", "normalize", "", "normalize$FilesKt__UtilsKt", "Lkotlin/io/FilePathComponents;", "relativeTo", "base", "relativeToOrNull", "relativeToOrSelf", "resolve", "relative", "resolveSibling", "startsWith", "toRelativeString", "toRelativeStringOrNull", "toRelativeStringOrNull$FilesKt__UtilsKt", "kotlin-stdlib"}, xs="kotlin/io/FilesKt")
class FilesKt__UtilsKt
extends FilesKt__FileTreeWalkKt {
    @Deprecated(message="Avoid creating temporary directories in the default temp location with this function due to too wide permissions on the newly created directory. Use kotlin.io.path.createTempDirectory instead.")
    public static final File createTempDir(String object, String string, File file) {
        Intrinsics.checkNotNullParameter(object, "");
        object = File.createTempFile((String)object, string, file);
        ((File)object).delete();
        if (((File)object).mkdir()) {
            Intrinsics.checkNotNull(object);
            return object;
        }
        throw new IOException("Unable to create temporary directory " + object + '.');
    }

    public static /* synthetic */ File createTempDir$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    @Deprecated(message="Avoid creating temporary files in the default temp location with this function due to too wide permissions on the newly created file. Use kotlin.io.path.createTempFile instead or resort to java.io.File.createTempFile.")
    public static final File createTempFile(String string, String string2, File file) {
        Intrinsics.checkNotNullParameter(string, "");
        File file2 = File.createTempFile(string, string2, file);
        Intrinsics.checkNotNullExpressionValue(file2, "");
        return file2;
    }

    public static /* synthetic */ File createTempFile$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    public static final String getExtension(File file) {
        Intrinsics.checkNotNullParameter(file, "");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return StringsKt.substringAfterLast(string, '.', "");
    }

    public static final String getInvariantSeparatorsPath(File file) {
        Intrinsics.checkNotNullParameter(file, "");
        if (File.separatorChar != '/') {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "");
            return StringsKt.replace$default(string, File.separatorChar, '/', false, 4, null);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public static final String getNameWithoutExtension(File file) {
        Intrinsics.checkNotNullParameter(file, "");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return StringsKt.substringBeforeLast$default(string, ".", null, 2, null);
    }

    public static final String toRelativeString(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(file2, "");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt(file, file2);
        if (string == null) {
            throw new IllegalArgumentException("this and base files have different roots: " + file + " and " + file2 + '.');
        }
        return string;
    }

    public static final File relativeTo(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(file2, "");
        return new File(FilesKt.toRelativeString(file, file2));
    }

    public static final File relativeToOrSelf(File object, File file) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(file, "");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt((File)object, file);
        if (string != null) {
            object = string;
            object = string;
            return new File((String)object);
        }
        return object;
    }

    public static final File relativeToOrNull(File object, File file) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(file, "");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt((File)object, file);
        if (string != null) {
            object = string;
            object = string;
            return new File((String)object);
        }
        return null;
    }

    private static final String toRelativeStringOrNull$FilesKt__UtilsKt(File object, File object2) {
        int n;
        object = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents((File)object));
        object2 = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents((File)object2));
        if (!Intrinsics.areEqual(((FilePathComponents)object).getRoot(), ((FilePathComponents)object2).getRoot())) {
            return null;
        }
        int n2 = ((FilePathComponents)object2).getSize();
        int n3 = ((FilePathComponents)object).getSize();
        int n4 = Math.min(n3, n2);
        for (n = 0; n < n4 && Intrinsics.areEqual(((FilePathComponents)object).getSegments().get(n), ((FilePathComponents)object2).getSegments().get(n)); ++n) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = n2 - 1;
        if (n <= n5) {
            while (true) {
                if (Intrinsics.areEqual(((FilePathComponents)object2).getSegments().get(n5).getName(), "..")) {
                    return null;
                }
                stringBuilder.append("..");
                if (n5 != n) {
                    stringBuilder.append(File.separatorChar);
                }
                if (n5 == n) break;
                --n5;
            }
        }
        if (n < n3) {
            if (n < n2) {
                stringBuilder.append(File.separatorChar);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)((FilePathComponents)object).getSegments(), n);
            Appendable appendable = stringBuilder;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue(string, "");
            CollectionsKt.joinTo$default(iterable, appendable, string, null, null, 0, null, null, 124, null);
        }
        return stringBuilder.toString();
    }

    public static final File copyTo(File object, File file, boolean bl, int n) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(file, "");
        if (!((File)object).exists()) {
            throw new NoSuchFileException((File)object, null, "The source file doesn't exist.", 2, null);
        }
        if (file.exists()) {
            if (!bl) {
                throw new FileAlreadyExistsException((File)object, file, "The destination file already exists.");
            }
            if (!file.delete()) {
                throw new FileAlreadyExistsException((File)object, file, "Tried to overwrite the destination, but failed to delete it.");
            }
        }
        if (((File)object).isDirectory()) {
            if (!file.mkdirs()) {
                throw new FileSystemException((File)object, file, "Failed to create target directory.");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            object = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                FileInputStream fileInputStream = (FileInputStream)object;
                Closeable closeable = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    FileOutputStream fileOutputStream = (FileOutputStream)closeable;
                    ByteStreamsKt.copyTo(fileInputStream, fileOutputStream, n);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable2);
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throwable = throwable5;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        return file;
    }

    public static /* synthetic */ File copyTo$default(File file, File file2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return FilesKt.copyTo(file, file2, bl, n);
    }

    public static final boolean copyRecursively(File file, File file2, boolean bl, Function2<? super File, ? super IOException, ? extends OnErrorAction> function2) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(file2, "");
        Intrinsics.checkNotNullParameter(function2, "");
        if (!file.exists()) {
            return function2.invoke(file, new NoSuchFileException(file, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown(file).onFail(new FilesKt__UtilsKt$copyRecursively$2(function2)).iterator();
            while (iterator2.hasNext()) {
                File file3 = iterator2.next();
                if (!file3.exists()) {
                    if (function2.invoke(file3, new NoSuchFileException(file3, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
                Object object = FilesKt.toRelativeString(file3, file);
                if (!(!((File)(object = new File(file2, (String)object))).exists() || file3.isDirectory() && ((File)object).isDirectory())) {
                    boolean bl2;
                    boolean bl3 = !bl ? true : (((File)object).isDirectory() ? !FilesKt.deleteRecursively((File)object) : (bl2 = !((File)object).delete()));
                    if (bl3) {
                        if (function2.invoke((File)object, new FileAlreadyExistsException(file3, (File)object, "The destination file already exists.")) != OnErrorAction.TERMINATE) continue;
                        return false;
                    }
                }
                if (file3.isDirectory()) {
                    ((File)object).mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(file3, (File)object, bl, 0, 4, null).length() == file3.length() || function2.invoke(file3, new IOException("Source file wasn't copied completely, length of destination file differs.")) != OnErrorAction.TERMINATE) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException terminateException) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function2 = FilesKt__UtilsKt$copyRecursively$1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, bl, function2);
    }

    public static final boolean deleteRecursively(File iterator2) {
        Intrinsics.checkNotNullParameter(iterator2, "");
        iterator2 = FilesKt.walkBottomUp((File)((Object)iterator2));
        boolean bl = true;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            File file = (File)t;
            boolean bl2 = bl;
            bl = (file.delete() || !file.exists()) && bl2;
        }
        return bl;
    }

    public static final boolean startsWith(File object, File object2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        object = FilesKt.toComponents((File)object);
        object2 = FilesKt.toComponents((File)object2);
        if (!Intrinsics.areEqual(((FilePathComponents)object).getRoot(), ((FilePathComponents)object2).getRoot())) {
            return false;
        }
        if (((FilePathComponents)object).getSize() < ((FilePathComponents)object2).getSize()) {
            return false;
        }
        return ((Object)((FilePathComponents)object).getSegments().subList(0, ((FilePathComponents)object2).getSize())).equals(((FilePathComponents)object2).getSegments());
    }

    public static final boolean startsWith(File file, String string) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(string, "");
        return FilesKt.startsWith(file, new File(string));
    }

    public static final boolean endsWith(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(file2, "");
        FilePathComponents filePathComponents = FilesKt.toComponents(file);
        FilePathComponents filePathComponents2 = FilesKt.toComponents(file2);
        if (filePathComponents2.isRooted()) {
            return Intrinsics.areEqual(file, file2);
        }
        int n = filePathComponents.getSize() - filePathComponents2.getSize();
        if (n < 0) {
            return false;
        }
        return ((Object)filePathComponents.getSegments().subList(n, filePathComponents.getSize())).equals(filePathComponents2.getSegments());
    }

    public static final boolean endsWith(File file, String string) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(string, "");
        return FilesKt.endsWith(file, new File(string));
    }

    public static final File normalize(File object) {
        Intrinsics.checkNotNullParameter(object, "");
        FilePathComponents filePathComponents = FilesKt.toComponents((File)object);
        object = filePathComponents;
        object = filePathComponents;
        File file = filePathComponents.getRoot();
        Iterable iterable = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(((FilePathComponents)object).getSegments());
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue(string, "");
        return FilesKt.resolve(file, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null));
    }

    private static final FilePathComponents normalize$FilesKt__UtilsKt(FilePathComponents filePathComponents) {
        return new FilePathComponents(filePathComponents.getRoot(), FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents.getSegments()));
    }

    private static final List<File> normalize$FilesKt__UtilsKt(List<? extends File> object) {
        List list = new ArrayList(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            String string = file.getName();
            if (Intrinsics.areEqual(string, ".")) continue;
            if (Intrinsics.areEqual(string, "..")) {
                if (!list.isEmpty() && !Intrinsics.areEqual(((File)CollectionsKt.last(list)).getName(), "..")) {
                    List list2 = list;
                    list2.remove(list2.size() - 1);
                    continue;
                }
                list.add(file);
                continue;
            }
            list.add(file);
        }
        return list;
    }

    public static final File resolve(File object, File file) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(file, "");
        if (FilesKt.isRooted(file)) {
            return file;
        }
        String string = ((File)object).toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        object = string;
        if (((CharSequence)string).length() == 0 || StringsKt.endsWith$default((CharSequence)object, File.separatorChar, false, 2, null)) {
            return new File((String)object + file);
        }
        return new File((String)object + File.separatorChar + file);
    }

    public static final File resolve(File file, String string) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(string, "");
        return FilesKt.resolve(file, new File(string));
    }

    public static final File resolveSibling(File object, File file) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(file, "");
        object = FilesKt.toComponents((File)object);
        File file2 = ((FilePathComponents)object).getSize() == 0 ? new File("..") : ((FilePathComponents)object).subPath(0, ((FilePathComponents)object).getSize() - 1);
        return FilesKt.resolve(FilesKt.resolve(((FilePathComponents)object).getRoot(), file2), file);
    }

    public static final File resolveSibling(File file, String string) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(string, "");
        return FilesKt.resolveSibling(file, new File(string));
    }
}

