/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.ReflectionUtil$findAssignableField$result$1;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010#\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\b\u0001\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u0004\u0018\u00010\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00062\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\rJ*\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\b\u0001\u0010\b\u001a\u00020\tJ=\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0011\u001a\u00020\t2\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0013\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019JA\u0010\u001a\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001dJC\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00132\u0012\u0010 \u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00060!2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\r\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lorg/jetbrains/skiko/ReflectionUtil;", "", "()V", "findAssignableField", "Ljava/lang/reflect/Field;", "clazz", "Ljava/lang/Class;", "fieldType", "fieldName", "", "findFieldInHierarchy", "rootClass", "checker", "Ljava/util/function/Predicate;", "getAssignableField", "getDeclaredMethodOrNull", "Ljava/lang/reflect/Method;", "name", "parameters", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getFieldValue", "T", "field", "instance", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;", "getFieldValueOrNull", "objectClass", "object", "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "processInterfaces", "interfaces", "visited", "", "([Ljava/lang/Class;Ljava/util/Set;Ljava/util/function/Predicate;)Ljava/lang/reflect/Field;", "skiko"})
public final class ReflectionUtil {
    public static final ReflectionUtil INSTANCE = new ReflectionUtil();

    private ReflectionUtil() {
    }

    public final Method getDeclaredMethodOrNull(Class<?> genericDeclaration, String object, Class<?> ... classArray) {
        Intrinsics.checkNotNullParameter(genericDeclaration, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(classArray, (String)"");
        try {
            genericDeclaration = genericDeclaration.getDeclaredMethod((String)object, Arrays.copyOf(classArray, classArray.length));
            object = genericDeclaration;
            ((Method)genericDeclaration).setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            genericDeclaration = null;
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            genericDeclaration = null;
        }
        return genericDeclaration;
    }

    public final <T> T getFieldValueOrNull(Class<?> annotatedElement, Object object, Class<T> clazz, String string) {
        Intrinsics.checkNotNullParameter(annotatedElement, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            annotatedElement = this.getAssignableField((Class<?>)annotatedElement, clazz, string);
            annotatedElement = this.getFieldValue((Field)annotatedElement, object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            annotatedElement = null;
        }
        return (T)annotatedElement;
    }

    public final Field getAssignableField(Class<?> clazz, Class<?> clazz2, String string) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Field field = this.findAssignableField(clazz, clazz2, string);
        if (field == null) {
            throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + string + " fieldType: " + clazz2);
        }
        return field;
    }

    public final Field findAssignableField(Class<?> annotatedElement, Class<?> clazz, String string) {
        Intrinsics.checkNotNullParameter(annotatedElement, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        annotatedElement = this.findFieldInHierarchy((Class<?>)annotatedElement, arg_0 -> ReflectionUtil.findAssignableField$lambda$1(new ReflectionUtil$findAssignableField$result$1(string, clazz), arg_0));
        return annotatedElement;
    }

    public final Field findFieldInHierarchy(Class<?> clazz, Predicate<? super Field> predicate) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter(predicate, (String)"");
        try {
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Field[] fieldArray;
                Intrinsics.checkNotNullExpressionValue((Object)clazz2.getDeclaredFields(), (String)"");
                for (Field field : fieldArray) {
                    Intrinsics.checkNotNullExpressionValue((Object)field, (String)"");
                    if (!predicate.test(field)) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            return null;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
        return this.processInterfaces(classArray, new HashSet(), predicate);
    }

    public final Field processInterfaces(Class<?>[] classArray, Set<? super Class<?>> set, Predicate<? super Field> predicate) {
        Intrinsics.checkNotNullParameter(classArray, (String)"");
        Intrinsics.checkNotNullParameter(set, (String)"");
        Intrinsics.checkNotNullParameter(predicate, (String)"");
        for (Class<?> clazz : classArray) {
            Field[] fieldArray;
            if (!set.add(clazz)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)clazz.getDeclaredFields(), (String)"");
            for (Field field : fieldArray) {
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"");
                if (!predicate.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Class<?>[] classArray2 = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray2, (String)"");
            Field object = this.processInterfaces(classArray2, set, predicate);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public final <T> T getFieldValue(Field object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        try {
            object = ((Field)object).get(object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = null;
        }
        return (T)object;
    }

    private static final boolean findAssignableField$lambda$1(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        return (Boolean)function1.invoke(object);
    }
}

