/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities$Private;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities$Public;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities$PackageVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities$ProtectedAndPackage;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities$ProtectedStaticVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java16SealedRecordLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$constructors$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$constructors$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$fields$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$fields$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$innerClassNames$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$innerClassNames$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$methods$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$methods$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    private final Class<?> klass;

    public ReflectJavaClass(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        this.klass = clazz;
    }

    @Override
    public final Class<?> getElement() {
        return this.klass;
    }

    @Override
    public final int getModifiers() {
        return this.klass.getModifiers();
    }

    public final List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])classArray), (Function1)ReflectJavaClass$innerClassNames$1.INSTANCE), (Function1)ReflectJavaClass$innerClassNames$2.INSTANCE));
    }

    @Override
    public final FqName getFqName() {
        FqName fqName2 = ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        return fqName2;
    }

    @Override
    public final ReflectJavaClass getOuterClass() {
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            Class<?> clazz2 = clazz;
            return new ReflectJavaClass(clazz2);
        }
        return null;
    }

    @Override
    public final Collection<JavaClassifierType> getSupertypes() {
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        Object object = new SpreadBuilder(2);
        Type type2 = this.klass.getGenericSuperclass();
        if (type2 == null) {
            type2 = (Type)((Object)Object.class);
        }
        object.add((Object)type2);
        Type[] typeArray = this.klass.getGenericInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        object.addSpread((Object)typeArray);
        SpreadBuilder spreadBuilder = object;
        Object object2 = object = (Iterable)CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()]));
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (Type)object3;
            Object object4 = object;
            object4.add(new ReflectJavaClassifierType((Type)object3));
        }
        return (List)object;
    }

    public final List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)new ReflectJavaClass$methods$1(this)), (Function1)ReflectJavaClass$methods$2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method objectArray) {
        String string = objectArray.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"values")) {
            Class<?>[] classArray = objectArray.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
            return ((Object[])classArray).length == 0;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"valueOf")) {
            Object[] objectArray2 = objectArray.getParameterTypes();
            Object[] objectArray3 = new Class[1];
            objectArray = objectArray3;
            objectArray3[0] = String.class;
            return Arrays.equals(objectArray2, objectArray);
        }
        return false;
    }

    public final List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)ReflectJavaClass$fields$1.INSTANCE), (Function1)ReflectJavaClass$fields$2.INSTANCE));
    }

    public final List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])constructorArray), (Function1)ReflectJavaClass$constructors$1.INSTANCE), (Function1)ReflectJavaClass$constructors$2.INSTANCE));
    }

    @Override
    public final boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    public final LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    public final Name getName() {
        if (this.klass.isAnonymousClass()) {
            String string = this.klass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            Name name = Name.identifier(StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null));
            Intrinsics.checkNotNull((Object)name);
            return name;
        }
        Name name = Name.identifier(this.klass.getSimpleName());
        Intrinsics.checkNotNull((Object)name);
        return name;
    }

    public final List<ReflectJavaTypeParameter> getTypeParameters() {
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"");
        Object object = typeVariableArray;
        Object[] objectArray = object;
        object = new ArrayList(((Object[])object).length);
        for (Object object2 : objectArray) {
            object2 = (TypeVariable)object2;
            Object object3 = object;
            object3.add(new ReflectJavaTypeParameter((TypeVariable<?>)object2));
        }
        return (List)object;
    }

    @Override
    public final boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public final boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public final boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public final boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    @Override
    public final Collection<JavaRecordComponent> getRecordComponents() {
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object object = objectArray;
        Object[] objectArray2 = objectArray;
        object = new ArrayList(((Object[])object).length);
        for (Object object2 : objectArray2) {
            Object object3 = object;
            object3.add(new ReflectJavaRecordComponent(object2));
        }
        return (List)object;
    }

    @Override
    public final boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    @Override
    public final Collection<JavaClassifierType> getPermittedTypes() {
        Object object = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (object != null) {
            Class<?>[] classArray = object;
            object = new ArrayList(((Class<?>[])object).length);
            for (Type type2 : classArray) {
                type2 = type2;
                Object object2 = object;
                object2.add(new ReflectJavaClassifierType(type2));
            }
            return (List)object;
        }
        return CollectionsKt.emptyList();
    }

    public final boolean equals(Object object) {
        return object instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)object).klass);
    }

    public final int hashCode() {
        return this.klass.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    public static final /* synthetic */ boolean access$isEnumValuesOrValueOf(ReflectJavaClass reflectJavaClass, Method method) {
        return reflectJavaClass.isEnumValuesOrValueOf(method);
    }

    @Override
    public final List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public final ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Annotation[] annotationArray = this.getElement();
        if (annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null) {
            return ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, fqName2);
        }
        return null;
    }

    @Override
    public final boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public final boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public final Visibility getVisibility() {
        int n = this.getModifiers();
        if (Modifier.isPublic(n)) {
            return Visibilities$Public.INSTANCE;
        }
        if (Modifier.isPrivate(n)) {
            return Visibilities$Private.INSTANCE;
        }
        if (Modifier.isProtected(n)) {
            if (Modifier.isStatic(n)) {
                return JavaVisibilities$ProtectedStaticVisibility.INSTANCE;
            }
            return JavaVisibilities$ProtectedAndPackage.INSTANCE;
        }
        return JavaVisibilities$PackageVisibility.INSTANCE;
    }
}

