/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType$Factory;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class ReflectJavaClassifierType
extends ReflectJavaType
implements JavaClassifierType {
    private final Type reflectType;
    private final JavaClassifier classifier;

    public ReflectJavaClassifierType(Type object) {
        JavaClassifier javaClassifier;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.reflectType = object;
        object = this;
        ReflectJavaClassifierType reflectJavaClassifierType = object;
        object = ((ReflectJavaClassifierType)object).getReflectType();
        Type type2 = object;
        if (object instanceof Class) {
            javaClassifier = new ReflectJavaClass((Class)object);
        } else if (type2 instanceof TypeVariable) {
            javaClassifier = new ReflectJavaTypeParameter((TypeVariable)object);
        } else if (type2 instanceof ParameterizedType) {
            Type type3 = ((ParameterizedType)object).getRawType();
            Intrinsics.checkNotNull((Object)type3);
            javaClassifier = new ReflectJavaClass((Class)type3);
        } else {
            throw new IllegalStateException("Not a classifier type (" + object.getClass() + "): " + object);
        }
        object = javaClassifier;
        reflectJavaClassifierType.classifier = javaClassifier;
    }

    @Override
    public final Type getReflectType() {
        return this.reflectType;
    }

    @Override
    public final JavaClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    public final String getClassifierQualifiedName() {
        throw new UnsupportedOperationException("Type not found: " + this.getReflectType());
    }

    @Override
    public final String getPresentableText() {
        return this.getReflectType().toString();
    }

    @Override
    public final boolean isRaw() {
        Type type2 = this.getReflectType();
        if (type2 instanceof Class) {
            TypeVariable<Class<T>>[] typeVariableArray = ((Class)type2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"");
            if (!(((Object[])typeVariableArray).length == 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final List<JavaType> getTypeArguments() {
        Iterable iterable = ReflectClassUtilKt.getParameterizedTypeArguments(this.getReflectType());
        ReflectJavaType$Factory reflectJavaType$Factory = ReflectJavaType.Factory;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (Type)object2;
            Iterable iterable2 = iterable;
            iterable2.add(reflectJavaType$Factory.create((Type)object2));
        }
        return (List)iterable;
    }

    @Override
    public final Collection<JavaAnnotation> getAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    public final JavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return null;
    }

    @Override
    public final boolean isDeprecatedInJavaDoc() {
        return false;
    }
}

