/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader$Kind;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;

public final class KotlinClassHeader {
    private final KotlinClassHeader$Kind kind;
    private final JvmMetadataVersion metadataVersion;
    private final String[] data;
    private final String[] incompatibleData;
    private final String[] strings;
    private final String extraString;
    private final int extraInt;
    private final String packageName;
    private final byte[] serializedIr;

    public KotlinClassHeader(KotlinClassHeader$Kind kotlinClassHeader$Kind, JvmMetadataVersion jvmMetadataVersion, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int n, String string2, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinClassHeader$Kind), (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        this.kind = kotlinClassHeader$Kind;
        this.metadataVersion = jvmMetadataVersion;
        this.data = stringArray;
        this.incompatibleData = stringArray2;
        this.strings = stringArray3;
        this.extraString = string;
        this.extraInt = n;
        this.packageName = string2;
        this.serializedIr = byArray;
    }

    public final KotlinClassHeader$Kind getKind() {
        return this.kind;
    }

    public final JvmMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    public final String[] getData() {
        return this.data;
    }

    public final String[] getIncompatibleData() {
        return this.incompatibleData;
    }

    public final String[] getStrings() {
        return this.strings;
    }

    public final String getMultifileClassName() {
        String string = this.extraString;
        if (this.kind == KotlinClassHeader$Kind.MULTIFILE_CLASS_PART) {
            return string;
        }
        return null;
    }

    public final List<String> getMultifilePartNames() {
        Object[] objectArray = this.data;
        Object object = this.kind == KotlinClassHeader$Kind.MULTIFILE_CLASS ? objectArray : null;
        List list = object != null ? ArraysKt.asList((Object[])object) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isUnstableJvmIrBinary() {
        KotlinClassHeader kotlinClassHeader = this;
        if (kotlinClassHeader.has(kotlinClassHeader.extraInt, 16)) {
            KotlinClassHeader kotlinClassHeader2 = this;
            if (!kotlinClassHeader2.has(kotlinClassHeader2.extraInt, 32)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isUnstableFirBinary() {
        KotlinClassHeader kotlinClassHeader = this;
        if (kotlinClassHeader.has(kotlinClassHeader.extraInt, 64)) {
            KotlinClassHeader kotlinClassHeader2 = this;
            if (!kotlinClassHeader2.has(kotlinClassHeader2.extraInt, 32)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isPreRelease() {
        KotlinClassHeader kotlinClassHeader = this;
        return kotlinClassHeader.has(kotlinClassHeader.extraInt, 2);
    }

    public final String toString() {
        return (Object)((Object)this.kind) + " version=" + this.metadataVersion;
    }

    private final boolean has(int n, int n2) {
        return (n & n2) != 0;
    }
}

