/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion$Companion;

public abstract class BinaryVersion {
    public static final BinaryVersion$Companion Companion = new BinaryVersion$Companion(null);
    private final int[] numbers;
    private final int major;
    private final int minor;
    private final int patch;
    private final List<Integer> rest;

    public BinaryVersion(int ... nArray) {
        List list;
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.numbers = nArray;
        Integer n = ArraysKt.getOrNull((int[])this.numbers, (int)0);
        this.major = n != null ? n : -1;
        Integer n2 = ArraysKt.getOrNull((int[])this.numbers, (int)1);
        this.minor = n2 != null ? n2 : -1;
        Integer n3 = ArraysKt.getOrNull((int[])this.numbers, (int)2);
        int n4 = this.patch = n3 != null ? n3 : -1;
        if (this.numbers.length > 3) {
            if (this.numbers.length > 1024) {
                throw new IllegalArgumentException("BinaryVersion with length more than 1024 are not supported. Provided length " + this.numbers.length + '.');
            }
            list = CollectionsKt.toList((Iterable)ArraysKt.asList((int[])this.numbers).subList(3, this.numbers.length));
        } else {
            list = CollectionsKt.emptyList();
        }
        this.rest = list;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int[] toArray() {
        return this.numbers;
    }

    protected final boolean isCompatibleTo(BinaryVersion binaryVersion) {
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        if (this.major == 0) {
            return binaryVersion.major == 0 && this.minor == binaryVersion.minor;
        }
        return this.major == binaryVersion.major && this.minor <= binaryVersion.minor;
    }

    public final boolean isAtLeast(BinaryVersion binaryVersion) {
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        return this.isAtLeast(binaryVersion.major, binaryVersion.minor, binaryVersion.patch);
    }

    public final boolean isAtLeast(int n, int n2, int n3) {
        if (this.major > n) {
            return true;
        }
        if (this.major < n) {
            return false;
        }
        if (this.minor > n2) {
            return true;
        }
        if (this.minor < n2) {
            return false;
        }
        return this.patch >= n3;
    }

    public final boolean isAtMost(int n, int n2, int n3) {
        if (this.major < n) {
            return true;
        }
        if (this.major > n) {
            return false;
        }
        if (this.minor < n2) {
            return true;
        }
        if (this.minor > n2) {
            return false;
        }
        return this.patch <= n3;
    }

    public String toString() {
        Object object = this.toArray();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = object[i];
            if (!(n2 != -1)) break;
            arrayList.add(n2);
        }
        List list = arrayList;
        object = list;
        if (list.isEmpty()) {
            return "unknown";
        }
        return CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(Object object) {
        return object != null && Intrinsics.areEqual(this.getClass(), object.getClass()) && this.major == ((BinaryVersion)object).major && this.minor == ((BinaryVersion)object).minor && this.patch == ((BinaryVersion)object).patch && Intrinsics.areEqual(this.rest, ((BinaryVersion)object).rest);
    }

    public int hashCode() {
        int n = this.major;
        n += n * 31 + this.minor;
        n += n * 31 + this.patch;
        n += n * 31 + ((Object)this.rest).hashCode();
        return n;
    }
}

