/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet$FieldDescriptorLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal$EnumLite;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyField;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyField$LazyIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat$FieldType;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat$JavaType;

final class FieldSet<FieldDescriptorType extends FieldSet$FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField = false;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean bl) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldSet$FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldSet$FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public final FieldSet<FieldDescriptorType> clone() {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite;
        FieldSet fieldSet = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldSet$FieldDescriptorLite, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldSet$FieldDescriptorLite, entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public final Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField$LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public final boolean hasField(FieldDescriptorType FieldDescriptorType) {
        if (FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(FieldDescriptorType) != null;
    }

    public final Object getField(FieldDescriptorType object) {
        if ((object = this.fields.get(object)) instanceof LazyField) {
            return ((LazyField)object).getValue();
        }
        return object;
    }

    public final void setField(FieldDescriptorType FieldDescriptorType, Object object) {
        if (FieldDescriptorType.isRepeated()) {
            if (!(object instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll((List)object);
            for (Object e : arrayList) {
                FieldSet.verifyType(FieldDescriptorType.getLiteType(), e);
            }
            object = arrayList;
        } else {
            FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        }
        if (object instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(FieldDescriptorType, object);
    }

    public final int getRepeatedFieldCount(FieldDescriptorType object) {
        if (!object.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        if ((object = this.getField(object)) == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public final Object getRepeatedField(FieldDescriptorType object, int n) {
        if (!object.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        if ((object = this.getField(object)) == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(n);
    }

    public final void addRepeatedField(FieldDescriptorType FieldDescriptorType, Object object) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        ArrayList<Object> arrayList = this.getField(FieldDescriptorType);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(FieldDescriptorType, (Object)arrayList);
        } else {
            arrayList = arrayList;
        }
        arrayList.add(object);
    }

    private static void verifyType(WireFormat$FieldType wireFormat$FieldType, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        switch (wireFormat$FieldType.getJavaType()) {
            case INT: {
                boolean bl2 = object instanceof Integer;
                break;
            }
            case LONG: {
                boolean bl2 = object instanceof Long;
                break;
            }
            case FLOAT: {
                boolean bl2 = object instanceof Float;
                break;
            }
            case DOUBLE: {
                boolean bl2 = object instanceof Double;
                break;
            }
            case BOOLEAN: {
                boolean bl2 = object instanceof Boolean;
                break;
            }
            case STRING: {
                boolean bl2 = object instanceof String;
                break;
            }
            case BYTE_STRING: {
                bl = object instanceof ByteString || object instanceof byte[];
                break;
            }
            case ENUM: {
                bl = object instanceof Integer || object instanceof Internal$EnumLite;
                break;
            }
            case MESSAGE: {
                boolean bl2 = bl = object instanceof MessageLite || object instanceof LazyField;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    public final boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            FieldSet fieldSet = this;
            if (fieldSet.isInitialized(fieldSet.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            if (this.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> iterator2) {
        Object object2 = (FieldSet$FieldDescriptorLite)iterator2.getKey();
        if (object2.getLiteJavaType() == WireFormat$JavaType.MESSAGE) {
            if (object2.isRepeated()) {
                for (Object object2 : (List)iterator2.getValue()) {
                    if (object2.isInitialized()) continue;
                    return false;
                }
            } else if ((iterator2 = iterator2.getValue()) instanceof MessageLite) {
                if (!((MessageLite)((Object)iterator2)).isInitialized()) {
                    return false;
                }
            } else {
                if (iterator2 instanceof LazyField) {
                    return true;
                }
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat$FieldType wireFormat$FieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return wireFormat$FieldType.getWireType();
    }

    public final void mergeFrom(FieldSet<FieldDescriptorType> object2) {
        for (int i = 0; i < ((FieldSet)object2).fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(((FieldSet)object2).fields.getArrayEntryAt(i));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : ((FieldSet)object2).fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private Object cloneIfMutable(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            object = byArray;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(object, 0, byArray2, 0, ((Object)object).length);
            return byArray2;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> iterator2) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)iterator2.getKey();
        if ((iterator2 = iterator2.getValue()) instanceof LazyField) {
            iterator2 = ((LazyField)((Object)iterator2)).getValue();
        }
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldSet$FieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            iterator2 = ((List)((Object)iterator2)).iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, (Object)arrayList);
                    return;
                }
                Object e = iterator2.next();
                ((List)arrayList).add(this.cloneIfMutable(e));
            }
        }
        if (fieldSet$FieldDescriptorLite.getLiteJavaType() != WireFormat$JavaType.MESSAGE) {
            this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, this.cloneIfMutable(iterator2));
            return;
        }
        Object object = this.getField(fieldSet$FieldDescriptorLite);
        if (object == null) {
            this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, this.cloneIfMutable(iterator2));
            return;
        }
        object = fieldSet$FieldDescriptorLite.internalMergeFrom(((MessageLite)object).toBuilder(), (MessageLite)((Object)iterator2)).build();
        this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, object);
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat$FieldType wireFormat$FieldType, boolean bl) {
        switch (wireFormat$FieldType) {
            case DOUBLE: {
                return codedInputStream.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(codedInputStream.readFloat());
            }
            case INT64: {
                return codedInputStream.readInt64();
            }
            case UINT64: {
                return codedInputStream.readUInt64();
            }
            case INT32: {
                return codedInputStream.readInt32();
            }
            case FIXED64: {
                return codedInputStream.readFixed64();
            }
            case FIXED32: {
                return codedInputStream.readFixed32();
            }
            case BOOL: {
                return codedInputStream.readBool();
            }
            case STRING: {
                if (bl) {
                    return codedInputStream.readStringRequireUtf8();
                }
                return codedInputStream.readString();
            }
            case BYTES: {
                return codedInputStream.readBytes();
            }
            case UINT32: {
                return codedInputStream.readUInt32();
            }
            case SFIXED32: {
                return codedInputStream.readSFixed32();
            }
            case SFIXED64: {
                return codedInputStream.readSFixed64();
            }
            case SINT32: {
                return codedInputStream.readSInt32();
            }
            case SINT64: {
                return codedInputStream.readSInt64();
            }
            case GROUP: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case MESSAGE: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case ENUM: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    private static void writeElement(CodedOutputStream codedOutputStream, WireFormat$FieldType wireFormat$FieldType, int n, Object object) {
        if (wireFormat$FieldType == WireFormat$FieldType.GROUP) {
            codedOutputStream.writeGroup(n, (MessageLite)object);
            return;
        }
        codedOutputStream.writeTag(n, FieldSet.getWireFormatForFieldType(wireFormat$FieldType, false));
        FieldSet.writeElementNoTag(codedOutputStream, wireFormat$FieldType, object);
    }

    private static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat$FieldType wireFormat$FieldType, Object object) {
        switch (wireFormat$FieldType) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag((Double)object);
                return;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                return;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                return;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                return;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                return;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                return;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                return;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                return;
            }
            case STRING: {
                codedOutputStream.writeStringNoTag((String)object);
                return;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                return;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                return;
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    return;
                }
                codedOutputStream.writeByteArrayNoTag((byte[])object);
                return;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                return;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                return;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                return;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                return;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                return;
            }
            case ENUM: {
                if (object instanceof Internal$EnumLite) {
                    codedOutputStream.writeEnumNoTag(((Internal$EnumLite)object).getNumber());
                    return;
                }
                codedOutputStream.writeEnumNoTag((Integer)object);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeField(FieldSet$FieldDescriptorLite<?> iterator2, Object object, CodedOutputStream codedOutputStream) {
        WireFormat$FieldType wireFormat$FieldType = iterator2.getLiteType();
        int n = iterator2.getNumber();
        if (iterator2.isRepeated()) {
            object = (List)object;
            if (iterator2.isPacked()) {
                codedOutputStream.writeTag(n, 2);
                int n2 = 0;
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    n2 += FieldSet.computeElementSizeNoTag(wireFormat$FieldType, e);
                }
                codedOutputStream.writeRawVarint32(n2);
                iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    FieldSet.writeElementNoTag(codedOutputStream, wireFormat$FieldType, e);
                }
                return;
            } else {
                iterator2 = object.iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    Object e = iterator2.next();
                    FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, e);
                }
            }
        }
        if (object instanceof LazyField) {
            FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, ((LazyField)object).getValue());
            return;
        }
        FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, object);
    }

    public final int getSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            n += FieldSet.computeFieldSize((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n += FieldSet.computeFieldSize((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n;
    }

    private static int computeElementSize(WireFormat$FieldType wireFormat$FieldType, int n, Object object) {
        n = CodedOutputStream.computeTagSize(n);
        if (wireFormat$FieldType == WireFormat$FieldType.GROUP) {
            n <<= 1;
        }
        return n + FieldSet.computeElementSizeNoTag(wireFormat$FieldType, object);
    }

    private static int computeElementSizeNoTag(WireFormat$FieldType wireFormat$FieldType, Object object) {
        switch (wireFormat$FieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case STRING: {
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])object);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case MESSAGE: {
                if (object instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)object);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case ENUM: {
                if (object instanceof Internal$EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal$EnumLite)object).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)object);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldSet$FieldDescriptorLite<?> fieldSet$FieldDescriptorLite, Object iterator2) {
        WireFormat$FieldType wireFormat$FieldType = fieldSet$FieldDescriptorLite.getLiteType();
        int n = fieldSet$FieldDescriptorLite.getNumber();
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            if (fieldSet$FieldDescriptorLite.isPacked()) {
                int n2 = 0;
                for (Object e : (List)((Object)iterator2)) {
                    n2 += FieldSet.computeElementSizeNoTag(wireFormat$FieldType, e);
                }
                return n2 + CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeRawVarint32Size(n2);
            }
            int n3 = 0;
            for (Object e : (List)((Object)iterator2)) {
                n3 += FieldSet.computeElementSize(wireFormat$FieldType, n, e);
            }
            return n3;
        }
        return FieldSet.computeElementSize(wireFormat$FieldType, n, iterator2);
    }
}

