/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMember;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;

public final class ReflectJavaMethod
extends ReflectJavaMember
implements JavaMethod {
    private final Method member;

    public ReflectJavaMethod(Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"");
        this.member = method;
    }

    @Override
    public final Method getMember() {
        return this.member;
    }

    @Override
    public final List<JavaValueParameter> getValueParameters() {
        ReflectJavaMethod reflectJavaMethod = this;
        Type[] typeArray = reflectJavaMethod.getMember().getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        Annotation[][] annotationArray = this.getMember().getParameterAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"");
        return reflectJavaMethod.getValueParameters(typeArray, annotationArray, this.getMember().isVarArgs());
    }

    @Override
    public final ReflectJavaType getReturnType() {
        Type type2 = this.getMember().getGenericReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
        return ReflectJavaType.Factory.create(type2);
    }

    @Override
    public final JavaAnnotationArgument getAnnotationParameterDefaultValue() {
        ReflectJavaAnnotationArgument reflectJavaAnnotationArgument;
        Object object = this.getMember().getDefaultValue();
        if (object != null) {
            Object object2 = object;
            reflectJavaAnnotationArgument = ReflectJavaAnnotationArgument.Factory.create(object2, null);
        } else {
            reflectJavaAnnotationArgument = null;
        }
        return reflectJavaAnnotationArgument;
    }

    public final List<ReflectJavaTypeParameter> getTypeParameters() {
        TypeVariable<Method>[] typeVariableArray = this.getMember().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"");
        Object object = typeVariableArray;
        Object[] objectArray = object;
        object = new ArrayList(((Object[])object).length);
        for (Object object2 : objectArray) {
            object2 = (TypeVariable)object2;
            Object object3 = object;
            object3.add(new ReflectJavaTypeParameter((TypeVariable<?>)object2));
        }
        return (List)object;
    }

    @Override
    public final boolean getHasAnnotationParameterDefaultValue() {
        return this.getAnnotationParameterDefaultValue() != null;
    }
}

