/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ReflectJavaValueParameter
extends ReflectJavaElement
implements JavaValueParameter {
    private final ReflectJavaType type;
    private final Annotation[] reflectAnnotations;
    private final String reflectName;
    private final boolean isVararg;

    public ReflectJavaValueParameter(ReflectJavaType reflectJavaType, Annotation[] annotationArray, String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)reflectJavaType, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotationArray, (String)"");
        this.type = reflectJavaType;
        this.reflectAnnotations = annotationArray;
        this.reflectName = string;
        this.isVararg = bl;
    }

    @Override
    public final ReflectJavaType getType() {
        return this.type;
    }

    @Override
    public final boolean isVararg() {
        return this.isVararg;
    }

    public final List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwnerKt.getAnnotations(this.reflectAnnotations);
    }

    @Override
    public final ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return ReflectJavaAnnotationOwnerKt.findAnnotation(this.reflectAnnotations, fqName2);
    }

    @Override
    public final boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public final Name getName() {
        String string = this.reflectName;
        if (string != null) {
            String string2 = string;
            return Name.guessByFirstCharacter(string);
        }
        return null;
    }

    public final String toString() {
        return this.getClass().getName() + ": " + (this.isVararg() ? "vararg " : "") + this.getName() + ": " + this.getType();
    }
}

