/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.TypeIntersectionScope;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$createType$1;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$makeDebugNameForIntersectionType$$inlined$sortedBy$1;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$makeDebugNameForIntersectionType$1;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$makeDebugNameForIntersectionType$3;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.IntersectionTypeConstructorMarker;

public final class IntersectionTypeConstructor
implements TypeConstructor,
IntersectionTypeConstructorMarker {
    private KotlinType alternative;
    private final LinkedHashSet<KotlinType> intersectedTypes;
    private final int hashCode;

    public IntersectionTypeConstructor(Collection<? extends KotlinType> object) {
        boolean bl;
        Intrinsics.checkNotNullParameter(object, (String)"");
        boolean bl2 = bl = !object.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            object = "Attempt to create an empty intersection";
            throw new AssertionError(object);
        }
        this.intersectedTypes = new LinkedHashSet(object);
        this.hashCode = this.intersectedTypes.hashCode();
    }

    private IntersectionTypeConstructor(Collection<? extends KotlinType> collection, KotlinType kotlinType) {
        this(collection);
        this.alternative = kotlinType;
    }

    @Override
    public final List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public final Collection<KotlinType> getSupertypes() {
        return this.intersectedTypes;
    }

    public final MemberScope createScopeForKotlinType() {
        return TypeIntersectionScope.Companion.create("member scope for intersection type", (Collection<? extends KotlinType>)this.intersectedTypes);
    }

    @Override
    public final boolean isDenotable() {
        return false;
    }

    @Override
    public final ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    public final KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = ((KotlinType)this.intersectedTypes.iterator().next()).getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"");
        return kotlinBuiltIns;
    }

    public final String toString() {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType$default(this, null, 1, null);
    }

    public final String makeDebugNameForIntersectionType(Function1<? super KotlinType, ? extends Object> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Iterable iterable = this.intersectedTypes;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new IntersectionTypeConstructor$makeDebugNameForIntersectionType$$inlined$sortedBy$1(function1)), (CharSequence)" & ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)new IntersectionTypeConstructor$makeDebugNameForIntersectionType$3(function1), (int)24, null);
    }

    public static /* synthetic */ String makeDebugNameForIntersectionType$default(IntersectionTypeConstructor intersectionTypeConstructor, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = IntersectionTypeConstructor$makeDebugNameForIntersectionType$1.INSTANCE;
        }
        return intersectionTypeConstructor.makeDebugNameForIntersectionType((Function1<? super KotlinType, ? extends Object>)function1);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntersectionTypeConstructor)) {
            return false;
        }
        return Intrinsics.areEqual(this.intersectedTypes, ((IntersectionTypeConstructor)object).intersectedTypes);
    }

    public final SimpleType createType() {
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), this, CollectionsKt.emptyList(), false, this.createScopeForKotlinType(), (Function1<? super KotlinTypeRefiner, ? extends SimpleType>)((Function1)new IntersectionTypeConstructor$createType$1(this)));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final IntersectionTypeConstructor refine(KotlinTypeRefiner kotlinTypeRefiner) {
        IntersectionTypeConstructor intersectionTypeConstructor;
        IntersectionTypeConstructor intersectionTypeConstructor2;
        KotlinType kotlinType;
        Object object;
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        IntersectionTypeConstructor intersectionTypeConstructor3 = this;
        boolean bl = false;
        Object object2 = object = (Iterable)intersectionTypeConstructor3.getSupertypes();
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object e = object2.next();
            kotlinType = (KotlinType)e;
            Iterable iterable = object;
            bl = true;
            iterable.add(kotlinType.refine(kotlinTypeRefiner));
        }
        object2 = (List)object;
        if (!bl) {
            intersectionTypeConstructor2 = null;
        } else {
            KotlinType kotlinType2;
            KotlinType kotlinType3 = intersectionTypeConstructor3.getAlternativeType();
            if (kotlinType3 != null) {
                object = kotlinType3;
                kotlinType = kotlinType3;
                kotlinType2 = kotlinType3.refine(kotlinTypeRefiner);
            } else {
                kotlinType2 = null;
            }
            object = kotlinType2;
            intersectionTypeConstructor2 = intersectionTypeConstructor = new IntersectionTypeConstructor((Collection)object2).setAlternative((KotlinType)object);
        }
        if (intersectionTypeConstructor2 == null) {
            intersectionTypeConstructor = this;
        }
        return intersectionTypeConstructor;
    }

    public final IntersectionTypeConstructor setAlternative(KotlinType kotlinType) {
        return new IntersectionTypeConstructor((Collection<? extends KotlinType>)this.intersectedTypes, kotlinType);
    }

    public final KotlinType getAlternativeType() {
        return this.alternative;
    }
}

