/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SubtypePathNode;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedureCallbacks;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;

public final class UtilsKt {
    public static final KotlinType findCorrespondingSupertype(KotlinType object, KotlinType object2, TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeCheckingProcedureCallbacks, (String)"");
        Object object3 = new ArrayDeque<SubtypePathNode>();
        ((ArrayDeque)object3).add(new SubtypePathNode((KotlinType)object, null));
        object = ((KotlinType)object2).getConstructor();
        while (!((ArrayDeque)object3).isEmpty()) {
            object2 = (SubtypePathNode)((ArrayDeque)object3).poll();
            KotlinType kotlinType3 = ((SubtypePathNode)object2).getType();
            Object object4 = kotlinType3.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors((TypeConstructor)object4, (TypeConstructor)object)) {
                object4 = kotlinType3;
                boolean bl = kotlinType3.isMarkedNullable();
                for (object2 = ((SubtypePathNode)object2).getPrevious(); object2 != null; object2 = ((SubtypePathNode)object2).getPrevious()) {
                    Object object5;
                    boolean bl2;
                    object3 = ((SubtypePathNode)object2).getType();
                    Object object6 = ((KotlinType)object3).getArguments();
                    if (!(object6 instanceof Collection) || !((Collection)object6).isEmpty()) {
                        object6 = object6.iterator();
                        while (object6.hasNext()) {
                            Object object7 = object6.next();
                            if (!((object7 = (TypeProjection)object7).getProjectionKind() != Variance.INVARIANT)) continue;
                            bl2 = true;
                            break;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        KotlinType kotlinType2 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create((KotlinType)object3), false, 1, null).buildSubstitutor().safeSubstitute((KotlinType)object4, Variance.INVARIANT);
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
                        object5 = UtilsKt.approximate(kotlinType2);
                    } else {
                        object6 = TypeConstructorSubstitution.Companion.create((KotlinType)object3).buildSubstitutor().safeSubstitute((KotlinType)object4, Variance.INVARIANT);
                        Intrinsics.checkNotNull((Object)object6);
                        object5 = object6;
                    }
                    object4 = object5;
                    bl = bl || ((KotlinType)object3).isMarkedNullable();
                }
                object3 = ((KotlinType)object4).getConstructor();
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors((TypeConstructor)object3, (TypeConstructor)object)) {
                    throw new AssertionError((Object)("Type constructors should be equals!\nsubstitutedSuperType: " + UtilsKt.debugInfo((TypeConstructor)object3) + ", \n\nsupertype: " + UtilsKt.debugInfo((TypeConstructor)object) + " \n" + typeCheckingProcedureCallbacks.assertEqualTypeConstructors((TypeConstructor)object3, (TypeConstructor)object)));
                }
                return TypeUtils.makeNullableAsSpecified(object4, bl);
            }
            for (KotlinType kotlinType3 : object4.getSupertypes()) {
                Intrinsics.checkNotNull((Object)kotlinType3);
                ((ArrayDeque)object3).add(new SubtypePathNode(kotlinType3, (SubtypePathNode)object2));
            }
        }
        return null;
    }

    private static final KotlinType approximate(KotlinType kotlinType) {
        return CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType).getUpper();
    }

    private static final String debugInfo(TypeConstructor object) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        UtilsKt.debugInfo$lambda$1$unaryPlus("type: " + object, stringBuilder2);
        UtilsKt.debugInfo$lambda$1$unaryPlus("hashCode: " + object.hashCode(), stringBuilder2);
        UtilsKt.debugInfo$lambda$1$unaryPlus("javaClass: " + object.getClass().getCanonicalName(), stringBuilder2);
        for (object = (DeclarationDescriptor)object.getDeclarationDescriptor(); object != null; object = object.getContainingDeclaration()) {
            UtilsKt.debugInfo$lambda$1$unaryPlus("fqName: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.render((DeclarationDescriptor)object), stringBuilder2);
            UtilsKt.debugInfo$lambda$1$unaryPlus("javaClass: " + object.getClass().getCanonicalName(), stringBuilder2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final StringBuilder debugInfo$lambda$1$unaryPlus(String string, StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"");
        StringBuilder stringBuilder3 = stringBuilder2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"");
        return stringBuilder3;
    }
}

